export declare const sampleData: {
    users: ({
        id: string;
        email: string;
        name: string;
        phoneNumber: string;
        dateOfBirth: Date;
        password: string;
        profilePic: string;
        roleId: string;
        creditId: string;
        address: {
            create: {
                address: string;
                city: string;
                state: string;
                country: string;
                postalCode: string;
            };
        };
    } | {
        id: string;
        email: string;
        name: string;
        phoneNumber: string;
        dateOfBirth: Date;
        password: string;
        profilePic: string;
        roleId: string;
        address: {
            create: {
                address: string;
                city: string;
                state: string;
                country: string;
                postalCode: string;
            };
        };
        creditId?: undefined;
    })[];
    merchants: {
        id: string;
        email: string;
        name: string;
        phoneNumber: string;
        dateOfBirth: Date;
        password: string;
        profilePic: string;
        roleId: string;
        merchant: {
            create: {
                id: string;
                name: string;
                businessType: string;
                businessRegistrationNumber: string;
                contractSigneeName: string;
                contractSigneeNRIC: string;
                address: {
                    create: {
                        address: string;
                        city: string;
                        state: string;
                        country: string;
                        postalCode: string;
                        latitude: number;
                        longitude: number;
                    };
                };
            };
        };
    }[];
    menus: {
        id: string;
        name: string;
        basePrice: number;
        category: string;
        description: string;
        merchantId: string;
        image: string;
        menuOptions: ({
            id: string;
            name: string;
            isRequired: boolean;
            min: number;
            max: number;
            options: {
                id: string;
                name: string;
                price: number;
                default: boolean;
            }[];
        } | {
            id: string;
            name: string;
            isRequired: boolean;
            min: number;
            max: number;
            options: {
                id: string;
                name: string;
                price: number;
            }[];
        })[];
    }[];
    roles: {
        id: string;
        name: string;
    }[];
    orders: {
        id: string;
        totalAmount: number;
        orderTime: Date;
        pickupTime: Date;
        status: string;
        merchantId: string;
        userId: string;
        orderDetails: {
            id: string;
            quantity: number;
            basePrice: number;
            orderDetailOptions: {
                id: string;
                type: string;
                name: string;
                price: number;
            }[];
        }[];
    }[];
    transactions: {
        id: string;
        totalAmount: number;
        paymentTime: Date;
        paymentMethod: string;
        orderId: string;
    }[];
    credit: {
        id: string;
        balance: number;
        userId: string;
        createdAt: Date;
    }[];
    creditHistory: {
        id: string;
        amount: number;
        actualAmount: number;
        type: string;
        status: string;
        lastCreditAmount: number;
        creditId: string;
        createdAt: Date;
        orderId: any;
    }[];
};
