"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const client_1 = require("@prisma/client");
const prisma = new client_1.PrismaClient();
function generateReferenceId() {
    const now = new Date();
    const year = now.getFullYear().toString().slice(-2);
    const month = String(now.getMonth() + 1).padStart(2, '0');
    const day = String(now.getDate()).padStart(2, '0');
    const datePrefix = `${year}${month}${day}`;
    const randomSuffix = this.nanoid();
    return `${datePrefix}-${randomSuffix}`;
}
async function updateExistingOrders() {
    const ordersWithoutRefId = await prisma.order.findMany({
        where: { referenceId: null },
    });
    for (const order of ordersWithoutRefId) {
        let referenceId;
        let exists;
        do {
            referenceId = generateReferenceId();
            const res = await prisma.order.findUnique({
                where: { referenceId },
            });
            exists = !!res;
        } while (exists);
        await prisma.order.update({
            where: { id: order.id },
            data: { referenceId },
        });
        console.log(`Updated Order ID ${order.id} with Reference ID ${referenceId}`);
    }
}
updateExistingOrders()
    .then(() => {
    console.log('All orders updated');
})
    .catch((error) => {
    console.error('Error updating orders:', error);
})
    .finally(async () => {
    await prisma.$disconnect();
});
//# sourceMappingURL=update-orders.js.map