"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrismaModel = void 0;
const user_1 = require("./user");
const user_vehicle_1 = require("./user_vehicle");
const merchant_1 = require("./merchant");
const address_1 = require("./address");
const menu_1 = require("./menu");
const menu_option_1 = require("./menu_option");
const option_1 = require("./option");
const order_1 = require("./order");
const order_details_1 = require("./order_details");
const order_detail_options_1 = require("./order_detail_options");
const transaction_1 = require("./transaction");
const rating_1 = require("./rating");
const role_1 = require("./role");
const credit_1 = require("./credit");
const credit_history_1 = require("./credit_history");
const billplz_1 = require("./billplz");
const voucher_1 = require("./voucher");
const tag_1 = require("./tag");
const tier_1 = require("./tier");
const loyalty_point_1 = require("./loyalty_point");
const loyalty_point_history_1 = require("./loyalty_point_history");
const merchandise_product_1 = require("./merchandise_product");
const user_redemption_history_1 = require("./user_redemption_history");
var PrismaModel;
(function (PrismaModel) {
    class User extends user_1.User {
    }
    PrismaModel.User = User;
    class UserVehicle extends user_vehicle_1.UserVehicle {
    }
    PrismaModel.UserVehicle = UserVehicle;
    class Merchant extends merchant_1.Merchant {
    }
    PrismaModel.Merchant = Merchant;
    class Address extends address_1.Address {
    }
    PrismaModel.Address = Address;
    class Menu extends menu_1.Menu {
    }
    PrismaModel.Menu = Menu;
    class MenuOption extends menu_option_1.MenuOption {
    }
    PrismaModel.MenuOption = MenuOption;
    class Option extends option_1.Option {
    }
    PrismaModel.Option = Option;
    class Order extends order_1.Order {
    }
    PrismaModel.Order = Order;
    class OrderDetails extends order_details_1.OrderDetails {
    }
    PrismaModel.OrderDetails = OrderDetails;
    class OrderDetailOptions extends order_detail_options_1.OrderDetailOptions {
    }
    PrismaModel.OrderDetailOptions = OrderDetailOptions;
    class Transaction extends transaction_1.Transaction {
    }
    PrismaModel.Transaction = Transaction;
    class Rating extends rating_1.Rating {
    }
    PrismaModel.Rating = Rating;
    class Role extends role_1.Role {
    }
    PrismaModel.Role = Role;
    class Credit extends credit_1.Credit {
    }
    PrismaModel.Credit = Credit;
    class CreditHistory extends credit_history_1.CreditHistory {
    }
    PrismaModel.CreditHistory = CreditHistory;
    class Billplz extends billplz_1.Billplz {
    }
    PrismaModel.Billplz = Billplz;
    class Voucher extends voucher_1.Voucher {
    }
    PrismaModel.Voucher = Voucher;
    class Tag extends tag_1.Tag {
    }
    PrismaModel.Tag = Tag;
    class Tier extends tier_1.Tier {
    }
    PrismaModel.Tier = Tier;
    class LoyaltyPoint extends loyalty_point_1.LoyaltyPoint {
    }
    PrismaModel.LoyaltyPoint = LoyaltyPoint;
    class LoyaltyPointHistory extends loyalty_point_history_1.LoyaltyPointHistory {
    }
    PrismaModel.LoyaltyPointHistory = LoyaltyPointHistory;
    class MerchandiseProduct extends merchandise_product_1.MerchandiseProduct {
    }
    PrismaModel.MerchandiseProduct = MerchandiseProduct;
    class UserRedemptionHistory extends user_redemption_history_1.UserRedemptionHistory {
    }
    PrismaModel.UserRedemptionHistory = UserRedemptionHistory;
    PrismaModel.extraModels = [
        User,
        UserVehicle,
        Merchant,
        Address,
        Menu,
        MenuOption,
        Option,
        Order,
        OrderDetails,
        OrderDetailOptions,
        Transaction,
        Rating,
        Role,
        Credit,
        CreditHistory,
        Billplz,
        Voucher,
        Tag,
        Tier,
        LoyaltyPoint,
        LoyaltyPointHistory,
        MerchandiseProduct,
        UserRedemptionHistory,
    ];
})(PrismaModel || (exports.PrismaModel = PrismaModel = {}));
//# sourceMappingURL=index.js.map