import { UserService } from '../user/user.service';
import { SignInDto, SignUpCustomerDto, SignUpMerchantDto, ResetPasswordDto, EmailResetPasswordDto, PasswordResetOtpDto, SetNewPasswordDto } from './auth.dto';
import { AuthService } from './auth.service';
import { SupabaseService } from './supabase.service';
export declare class AuthController {
    private authService;
    private userService;
    private supabaseService;
    constructor(authService: AuthService, userService: UserService, supabaseService: SupabaseService);
    userSignUp(data: SignUpCustomerDto): Promise<{
        data: {
            user: import("@supabase/auth-js").User | null;
            session: import("@supabase/auth-js").Session | null;
        } | {
            user: null;
            session: null;
        };
        message: string;
    }>;
    merchantSignUp(data: SignUpMerchantDto): Promise<{
        data: {
            user: import("@supabase/auth-js").User | null;
            session: import("@supabase/auth-js").Session | null;
        } | {
            user: null;
            session: null;
        };
        message: string;
    }>;
    login(userData: SignInDto): Promise<{
        data: {
            user: import("@supabase/auth-js").User;
            session: import("@supabase/auth-js").Session;
            weakPassword?: import("@supabase/auth-js").WeakPassword;
        } | {
            user: null;
            session: null;
            weakPassword?: null;
        };
        message: string;
    }>;
    signOut(): Promise<{
        data: {};
        message: string;
    }>;
    resetPassword(body: ResetPasswordDto): Promise<{
        data: {};
        message: string;
    }>;
    sentResetPasswordOtpToEmail(body: EmailResetPasswordDto): Promise<{
        data: {};
        message: string;
    }>;
    verifOpt(body: PasswordResetOtpDto): Promise<{
        data: {};
        message: string;
    }>;
    setNewPassword(body: SetNewPasswordDto): Promise<{
        data: {};
        message: string;
    }>;
}
