"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthController = void 0;
const common_1 = require("@nestjs/common");
const types_1 = require("../types");
const user_service_1 = require("../user/user.service");
const auth_dto_1 = require("./auth.dto");
const auth_service_1 = require("./auth.service");
const supabase_service_1 = require("./supabase.service");
let AuthController = class AuthController {
    constructor(authService, userService, supabaseService) {
        this.authService = authService;
        this.userService = userService;
        this.supabaseService = supabaseService;
    }
    async userSignUp(data) {
        const { email, password } = data;
        let existinguser = await this.authService.findUserByEmail(email);
        if (existinguser) {
            throw new common_1.HttpException({ error: 'This email is existed.' }, common_1.HttpStatus.BAD_REQUEST);
        }
        const { data: authData, error } = await this.supabaseService.signUpWithEmail(email, password);
        if (error) {
            throw new common_1.HttpException({ error: error['message'] }, common_1.HttpStatus.BAD_REQUEST);
        }
        await this.authService.createCustomer(data);
        return { data: authData, message: 'Customer successfully created' };
    }
    async merchantSignUp(data) {
        const { email, password } = data;
        let existinguser = await this.authService.findUserByEmail(email);
        if (existinguser) {
            throw new common_1.HttpException({ error: 'This email is existed.' }, common_1.HttpStatus.BAD_REQUEST);
        }
        const { data: authData, error } = await this.supabaseService.signUpWithEmail(email, password);
        if (error) {
            throw new common_1.HttpException({ error: error['message'] }, common_1.HttpStatus.BAD_REQUEST);
        }
        await this.authService.createMerchant(data);
        return { data: authData, message: 'Merchant successfully created' };
    }
    async login(userData) {
        const { email, password, platform } = userData;
        if (!platform) {
            throw new common_1.HttpException({ error: 'Missing Platform' }, common_1.HttpStatus.BAD_REQUEST);
        }
        let existingUser = await this.authService.findUserByEmail(email);
        if (!existingUser) {
            throw new common_1.HttpException({ error: 'This user does not exist in our system' }, common_1.HttpStatus.BAD_REQUEST);
        }
        if (platform === types_1.Platform.Customer) {
            if (existingUser.role.name !== types_1.Platform.Customer) {
                throw new common_1.HttpException({ error: 'This role should not login to Customer Portal' }, common_1.HttpStatus.BAD_REQUEST);
            }
        }
        else {
            if (existingUser.role.name !== types_1.Platform.Merchant) {
                throw new common_1.HttpException({ error: 'This role should not login to Merchant Portal' }, common_1.HttpStatus.BAD_REQUEST);
            }
        }
        if (existingUser) {
            const { data, error } = await this.supabaseService.signInWithEmail(email, password);
            if (data) {
                data['userData'] = await this.userService.findOneByEmail(email);
                return { data: data, message: 'Login Successfully.' };
            }
            else {
                throw new common_1.HttpException({ error: error['message'] }, common_1.HttpStatus.BAD_REQUEST);
            }
        }
        else {
            throw new common_1.HttpException({ error: 'User Not Found' }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async signOut() {
        const { error } = await this.supabaseService.signOut();
        if (!error) {
            return { data: {}, message: 'Sign Out Successfully.' };
        }
        else {
            throw new common_1.HttpException({ error: error['message'] }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async resetPassword(body) {
        const { error } = await this.supabaseService.ResetPassword(body);
        if (!error) {
            await this.supabaseService.signOut();
            return { data: {}, message: 'Reset Password Successfully.' };
        }
        else {
            throw new common_1.HttpException({ error: error['message'] }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async sentResetPasswordOtpToEmail(body) {
        const { error } = await this.supabaseService.sentResetPasswordEmail(body.email);
        if (!error) {
            return { data: {}, message: 'Reset Password Otp Email Sent Successfully.' };
        }
        else {
            throw new common_1.HttpException({ error: error['message'] }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async verifOpt(body) {
        const { error } = await this.supabaseService.verifyResetPasswordOtp(body.email, body.passwordResetOtp);
        if (!error) {
            return { data: {}, message: 'Verify Otp Successfully.' };
        }
        else {
            throw new common_1.HttpException({ error: error['message'] }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
    async setNewPassword(body) {
        const { error } = await this.supabaseService.setNewPassword(body);
        if (!error) {
            return { data: {}, message: 'Reset Password Successfully.' };
        }
        else {
            throw new common_1.HttpException({ error: error['message'] }, common_1.HttpStatus.BAD_REQUEST);
        }
    }
};
exports.AuthController = AuthController;
__decorate([
    (0, common_1.Post)('user/signup'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.SignUpCustomerDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "userSignUp", null);
__decorate([
    (0, common_1.Post)('merchant/signup'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.SignUpMerchantDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "merchantSignUp", null);
__decorate([
    (0, common_1.Post)('login'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.SignInDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "login", null);
__decorate([
    (0, common_1.Post)('signout'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "signOut", null);
__decorate([
    (0, common_1.Post)('resetpassword'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.ResetPasswordDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "resetPassword", null);
__decorate([
    (0, common_1.Post)('sentresetotp'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.EmailResetPasswordDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "sentResetPasswordOtpToEmail", null);
__decorate([
    (0, common_1.Post)('verifyotp'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.PasswordResetOtpDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "verifOpt", null);
__decorate([
    (0, common_1.Post)('setnewpassword'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [auth_dto_1.SetNewPasswordDto]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "setNewPassword", null);
exports.AuthController = AuthController = __decorate([
    (0, common_1.Controller)('auth'),
    __metadata("design:paramtypes", [auth_service_1.AuthService,
        user_service_1.UserService,
        supabase_service_1.SupabaseService])
], AuthController);
//# sourceMappingURL=auth.controller.js.map