import { SignUpCustomerDto, SignUpMerchantDto } from './auth.dto';
export declare class AuthService {
    constructor();
    createCustomer(data: SignUpCustomerDto): Promise<{
        id: string;
        email: string;
        name: string;
        roleId: string;
        phoneNumber: string;
        dateOfBirth: Date;
        addressId: string | null;
        profilePic: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
        creditId: string | null;
        loyaltyPointId: string | null;
    }>;
    createMerchant(data: SignUpMerchantDto): Promise<{
        id: string;
        email: string;
        name: string;
        roleId: string;
        phoneNumber: string;
        dateOfBirth: Date;
        addressId: string | null;
        profilePic: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
        creditId: string | null;
        loyaltyPointId: string | null;
    }>;
    findUserByEmail(email: string): Promise<{
        address: {
            id: string;
            address: string;
            city: string;
            state: string;
            country: string;
            postalCode: string;
            latitude: number | null;
            longitude: number | null;
            createdAt: Date;
            updatedAt: Date;
        };
        role: {
            id: string;
            name: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
    } & {
        id: string;
        email: string;
        name: string;
        roleId: string;
        phoneNumber: string;
        dateOfBirth: Date;
        addressId: string | null;
        profilePic: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
        creditId: string | null;
        loyaltyPointId: string | null;
    }>;
}
