"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const prisma_1 = require("../prisma");
let AuthService = class AuthService {
    constructor() { }
    async createCustomer(data) {
        const role = await prisma_1.default.role.findFirst({
            where: {
                name: 'Customer'
            }
        });
        if (!role) {
            throw new Error('Role Customer Not Found');
        }
        return prisma_1.default.user.create({
            data: {
                email: data.email,
                name: data.name,
                phoneNumber: data.phoneNumber,
                dateOfBirth: new Date(data.dateOfBirth),
                role: {
                    connect: {
                        id: role.id
                    }
                },
                address: {
                    create: {
                        address: data.address,
                        city: data.city,
                        state: data.state,
                        country: data.country,
                        postalCode: data.postalCode
                    }
                }
            }
        });
    }
    async createMerchant(data) {
        const role = await prisma_1.default.role.findFirst({
            where: {
                name: 'Merchant'
            }
        });
        if (!role) {
            throw new Error('Role Merchant Not Found');
        }
        return prisma_1.default.user.create({
            data: {
                email: data.email,
                name: data.name,
                phoneNumber: data.phoneNumber,
                dateOfBirth: new Date(data.dateOfBirth),
                role: {
                    connect: {
                        id: role.id
                    }
                },
                merchant: {
                    create: {
                        name: data.entityName,
                        businessType: data.businessType,
                        ...(data.businessRegistrationNumber && {
                            businessRegistrationNumber: data.businessRegistrationNumber
                        }),
                        ...(data.contractSigneeName && {
                            contractSigneeName: data.contractSigneeName
                        }),
                        ...(data.contractSigneeNRIC && {
                            contractSigneeNRIC: data.contractSigneeNRIC
                        }),
                        address: {
                            create: {
                                address: data.address,
                                city: data.city,
                                state: data.state,
                                country: data.country,
                                postalCode: data.postalCode
                            }
                        }
                    }
                },
            }
        });
    }
    async findUserByEmail(email) {
        return prisma_1.default.user.findUnique({
            where: {
                email,
            },
            include: {
                role: true,
                address: true
            }
        });
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], AuthService);
//# sourceMappingURL=auth.service.js.map