"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupabaseService = void 0;
const common_1 = require("@nestjs/common");
const supabase_js_1 = require("@supabase/supabase-js");
const prisma_1 = require("../prisma");
let SupabaseService = class SupabaseService {
    constructor() {
        this.supabase = (0, supabase_js_1.createClient)(process.env.SUPABASE_URL, process.env.DATABASE_PUBLIC_KEY);
    }
    async signUpWithEmail(email, password) {
        try {
            const { data, error } = await this.supabase.auth.signUp({
                email,
                password: password,
            });
            if (error) {
                return { error };
            }
            return {
                data,
                message: 'Verification email sent. Please check your inbox.',
            };
        }
        catch (error) {
            return { error: 'An error occurred during sign-up.' };
        }
    }
    async verifyOTP(email, otp) {
        try {
            const { data, error } = await this.supabase.auth.verifyOtp({
                email,
                token: otp,
                type: 'email',
            });
            if (error) {
                return { error };
            }
            return {
                data,
                message: 'OTP verified successfully.',
            };
        }
        catch (error) {
            return { error: 'An error occurred during OTP verification.' };
        }
    }
    async signInWithEmail(email, password) {
        try {
            const { data, error } = await this.supabase.auth.signInWithPassword({
                email: email,
                password: password,
            });
            if (error) {
                return { error };
            }
            return {
                data,
                message: 'Login successfully.',
            };
        }
        catch (error) {
            return { error: 'Login unsuccessfully.' };
        }
    }
    async deleteUserFromAuth(email) {
        await this.supabase.from('auth.users').delete().match({ email: email });
    }
    async validateUserSession(token) {
        await this.supabase.auth.getUser(token);
    }
    async signOut() {
        try {
            const currentUser = this.supabase.auth.getSession();
            if (currentUser) {
                const { error } = await this.supabase.auth.signOut();
                if (error) {
                    return { error };
                }
                return { message: 'Logout successful.' };
            }
            else {
                return { error: 'You do not have permission to sign out this user.' };
            }
        }
        catch (error) {
            return { error: 'Logout unsuccessful.' };
        }
    }
    async ResetPassword(password) {
        try {
            const currentUser = await this.supabase.auth.getUser();
            const { data, error } = await this.supabase.auth.signInWithPassword({
                email: currentUser.data.user.email,
                password: password.currentPassword,
            });
            if (error) {
                return { message: 'Current Password Not Match.' };
            }
            if (currentUser) {
                if (password.newPassword !== password.confirmNewPassword) {
                    return { message: 'New Password Not Match.' };
                }
                const { data, error } = await this.supabase.auth.updateUser({ password: password.newPassword });
                if (error) {
                    return { error };
                }
                return { message: 'Password reset successful.' };
            }
            else {
                return { error: 'You do not have permission to sign out this user.' };
            }
        }
        catch (error) {
            return { error: 'Password reset unsuccessful.' };
        }
    }
    async sentResetPasswordEmail(email) {
        try {
            const existingUser = await prisma_1.default.user.findUnique({
                where: {
                    email,
                }
            });
            if (existingUser) {
                const { data, error } = await this.supabase.auth.resetPasswordForEmail(email);
                if (error) {
                    return { error };
                }
                return { message: 'Password reset email sent successful.' };
            }
            else {
                return { message: 'Email Not Found.' };
            }
        }
        catch (error) {
            return { error: 'Password reset email sent unsuccessful.' };
        }
    }
    async verifyResetPasswordOtp(email, otp) {
        try {
            const { data, error } = await this.supabase.auth.verifyOtp({
                email,
                token: otp,
                type: 'email',
            });
            if (error) {
                return { error };
            }
            return {
                data,
                message: 'OTP verified successfully.',
            };
        }
        catch (error) {
            return { error: 'OTP verified unsuccessful.' };
        }
    }
    async setNewPassword(password) {
        try {
            const currentUser = await this.supabase.auth.getUser();
            if (currentUser) {
                if (password.newPassword !== password.confirmNewPassword) {
                    return { message: 'New Password Not Match.' };
                }
                const { data, error } = await this.supabase.auth.updateUser({ password: password.newPassword });
                if (error) {
                    return { error };
                }
                return { message: 'Password reset successful.' };
            }
            else {
                return { error: 'You do not have permission to sign out this user.' };
            }
        }
        catch (error) {
            return { error: 'Password reset unsuccessful.' };
        }
    }
};
exports.SupabaseService = SupabaseService;
exports.SupabaseService = SupabaseService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], SupabaseService);
exports.default = SupabaseService;
//# sourceMappingURL=supabase.service.js.map