import { CreditHistoryDto } from './credit-history.dto';
import { CreditHistoryService } from './credit-history.service';
export declare class CreditHistoryController {
    private creditHistoryService;
    constructor(creditHistoryService: CreditHistoryService);
    findCreditHistory(creditHistoryDto: CreditHistoryDto): Promise<{
        data: {
            creditWithHistory: {
                history: {
                    id: string;
                    amount: number;
                    actualAmount: number;
                    type: string;
                    status: string;
                    creditId: string | null;
                    orderId: string | null;
                    createdAt: Date;
                    updatedAt: Date | null;
                    lastCreditAmount: number | null;
                    billplzId: string | null;
                }[];
            } & {
                id: string;
                balance: number;
                userId: string;
                createdAt: Date;
                updatedAt: Date | null;
            };
            totalCount: number;
        };
        message: string;
    }>;
}
