"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreditHistoryService = void 0;
const common_1 = require("@nestjs/common");
const prisma_1 = require("../prisma");
let CreditHistoryService = class CreditHistoryService {
    constructor() { }
    async getUserCreditHistory(creditHistoryDto) {
        const whereClause = {};
        if (creditHistoryDto.startDate) {
            whereClause.createdAt = {
                ...whereClause.createdAt,
                gte: new Date(creditHistoryDto.startDate),
            };
        }
        if (creditHistoryDto.endDate) {
            whereClause.createdAt = {
                ...whereClause.createdAt,
                lte: new Date(creditHistoryDto.endDate),
            };
        }
        const creditWithHistory = await prisma_1.default.credit.findUnique({
            where: {
                userId: creditHistoryDto.userId,
            },
            include: {
                history: {
                    where: whereClause,
                    orderBy: {
                        createdAt: creditHistoryDto.orderBy,
                    },
                    skip: (creditHistoryDto.page - 1) * creditHistoryDto.numPerPage,
                    take: creditHistoryDto.numPerPage,
                },
            },
        });
        const totalCount = await prisma_1.default.creditHistory.count({
            where: {
                creditId: creditWithHistory.id,
                ...whereClause,
            },
        });
        return {
            creditWithHistory,
            totalCount,
        };
    }
};
exports.CreditHistoryService = CreditHistoryService;
exports.CreditHistoryService = CreditHistoryService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], CreditHistoryService);
//# sourceMappingURL=credit-history.service.js.map