"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreditController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const credit_service_1 = require("./credit.service");
const user_service_1 = require("../user/user.service");
const utils_1 = require("../utils");
let CreditController = class CreditController {
    constructor(creditService, userService) {
        this.creditService = creditService;
        this.userService = userService;
    }
    async findBalanceByUserId(userId) {
        const credit = await this.creditService.getUserBalance(userId);
        const user = await this.userService.findOne(userId);
        if ((0, utils_1.isEmpty)(credit) && !(0, utils_1.isEmpty)(user)) {
            console.log(`Found no registered Credit User & User is active user! Registering new Credit for ${user?.name}.`);
            return { data: await this.creditService.create(user), message: 'Find Credit Balance' };
        }
        return { data: credit, message: 'Find Credit Balance' };
    }
};
exports.CreditController = CreditController;
__decorate([
    (0, common_1.Get)(':id'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], CreditController.prototype, "findBalanceByUserId", null);
exports.CreditController = CreditController = __decorate([
    (0, swagger_1.ApiTags)('Credit'),
    (0, common_1.Controller)('credit'),
    __metadata("design:paramtypes", [credit_service_1.CreditService,
        user_service_1.UserService])
], CreditController);
//# sourceMappingURL=credit.controller.js.map