import { User } from '@prisma/client';
import { BillplzCallbackDto } from 'src/payment/payment.dto';
export declare class CreditService {
    constructor();
    getUserBalance(userId: string): Promise<{
        history: {
            id: string;
            amount: number;
            actualAmount: number;
            type: string;
            status: string;
            creditId: string | null;
            orderId: string | null;
            createdAt: Date;
            updatedAt: Date | null;
            lastCreditAmount: number | null;
            billplzId: string | null;
        }[];
    } & {
        id: string;
        balance: number;
        userId: string;
        createdAt: Date;
        updatedAt: Date | null;
    }>;
    create(user: User): Promise<{
        history: {
            id: string;
            amount: number;
            actualAmount: number;
            type: string;
            status: string;
            creditId: string | null;
            orderId: string | null;
            createdAt: Date;
            updatedAt: Date | null;
            lastCreditAmount: number | null;
            billplzId: string | null;
        }[];
    } & {
        id: string;
        balance: number;
        userId: string;
        createdAt: Date;
        updatedAt: Date | null;
    }>;
    addCredit(callBackData: BillplzCallbackDto): Promise<{
        id: string;
        balance: number;
        userId: string;
        createdAt: Date;
        updatedAt: Date | null;
    }>;
    createBillPlzRecords(callBackData: BillplzCallbackDto): Promise<{
        id: string;
        billplz_id: string;
        collection_id: string;
        paid: boolean;
        state: string;
        amount: number;
        paid_amount: number;
        due_at: string;
        email: string;
        mobile: string | null;
        name: string | null;
        url: string | null;
        paid_at: Date;
        x_signature: string;
    }>;
}
