"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreditService = void 0;
const common_1 = require("@nestjs/common");
const prisma_1 = require("../prisma");
const credit_dto_1 = require("./credit.dto");
let CreditService = class CreditService {
    constructor() { }
    async getUserBalance(userId) {
        return await prisma_1.default.credit.findFirst({
            where: { userId: userId },
            include: {
                history: {
                    orderBy: {
                        createdAt: 'desc',
                    },
                    take: 5,
                }
            }
        });
    }
    async create(user) {
        const newCredit = await prisma_1.default.credit.create({
            data: {
                balance: 0.00,
                userId: user.id,
                createdAt: new Date(),
                user: { connect: { id: user.id } },
            },
        });
        await prisma_1.default.user.update({
            where: { id: user.id },
            data: { creditId: newCredit.id },
        });
        return await this.getUserBalance(user.id);
    }
    async addCredit(callBackData) {
        const billplz = await this.createBillPlzRecords(callBackData);
        const amount = +callBackData.amount / 100;
        let user = await prisma_1.default.user.findUnique({
            where: { email: callBackData.email }
        });
        let credit = await prisma_1.default.credit.findUnique({
            where: { userId: user.id },
        });
        if (!credit) {
            credit = await prisma_1.default.credit.create({
                data: {
                    userId: user.id,
                    balance: 0,
                    createdAt: new Date(),
                    user: { connect: { id: user.id } },
                },
            });
            await prisma_1.default.user.update({
                where: { id: user.id },
                data: { creditId: credit.id },
            });
        }
        const updatedCredit = await prisma_1.default.credit.update({
            where: { userId: user.id },
            data: {
                balance: credit.balance + amount,
                updatedAt: new Date(),
            },
        });
        const creditHistory = await prisma_1.default.creditHistory.findFirst({
            where: { billplzId: billplz.id },
        });
        if (creditHistory) {
            await prisma_1.default.creditHistory.update({
                where: { id: creditHistory.id },
                data: {
                    actualAmount: billplz.paid_amount,
                    type: credit_dto_1.PaymentType.RELOAD,
                    updatedAt: new Date(),
                    lastCreditAmount: credit.balance
                },
            });
        }
        else {
            await prisma_1.default.creditHistory.create({
                data: {
                    amount: billplz.amount,
                    actualAmount: billplz.paid_amount,
                    type: credit_dto_1.PaymentType.RELOAD,
                    creditId: updatedCredit.id,
                    lastCreditAmount: credit.balance,
                    createdAt: new Date(),
                    updatedAt: new Date(),
                    billplzId: billplz.id,
                    status: billplz.state.toUpperCase()
                },
            });
        }
        return updatedCredit;
    }
    async createBillPlzRecords(callBackData) {
        const billplz = await prisma_1.default.billplz.create({
            data: {
                billplz_id: callBackData.id,
                collection_id: callBackData.collection_id,
                paid: (callBackData.paid === "true"),
                state: callBackData.state,
                amount: +callBackData.amount / 100,
                paid_amount: +callBackData.paid_amount / 100,
                due_at: callBackData.due_at,
                email: callBackData.email,
                mobile: callBackData?.mobile,
                name: callBackData.name,
                url: callBackData.url,
                paid_at: new Date(callBackData.paid_at),
                x_signature: callBackData.x_signature,
            },
        });
        return billplz;
    }
};
exports.CreditService = CreditService;
exports.CreditService = CreditService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], CreditService);
//# sourceMappingURL=credit.service.js.map