import { UserService } from 'src/user/user.service';
import { CreateProductDto, ListProductsDto, LoyaltyPointHistoryDto, MarkAsCollectedDto, RedeemProductDto, UpdateProductDto, UserRedemptionDto } from './membership.dto';
import { MembershipService } from './membership.service';
export declare class MembershipController {
    private membershipService;
    private userService;
    constructor(membershipService: MembershipService, userService: UserService);
    findBalanceByUserId(userId: string): Promise<{
        data: {
            loyaltyPoint: {
                history: {
                    id: string;
                    userId: string;
                    amount: number;
                    newTotal: number;
                    type: string;
                    orderId: string | null;
                    createdAt: Date;
                    updatedAt: Date | null;
                    lastLoyaltyPointAmount: number | null;
                    loyaltyPointId: string | null;
                }[];
            } & {
                id: string;
                balance: number;
                userId: string;
                createdAt: Date;
                updatedAt: Date | null;
            };
            membershipTier: {
                id: string;
                name: string;
                pointsRequired: number;
                pointsMultiplier: number;
            };
            name: string;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
        };
        message: string;
    }>;
    getMembershipDetails(userId: string): Promise<{
        id: string;
        balance: number;
        userId: string;
        createdAt: Date;
        updatedAt: Date | null;
    }>;
    findCreditHistory(loyaltyPointHistoryDto: LoyaltyPointHistoryDto): Promise<{
        data: {
            loyaltyPointHistory: {
                history: {
                    id: string;
                    userId: string;
                    amount: number;
                    newTotal: number;
                    type: string;
                    orderId: string | null;
                    createdAt: Date;
                    updatedAt: Date | null;
                    lastLoyaltyPointAmount: number | null;
                    loyaltyPointId: string | null;
                }[];
            } & {
                id: string;
                balance: number;
                userId: string;
                createdAt: Date;
                updatedAt: Date | null;
            };
            totalCount: number;
        };
        message: string;
    }>;
    createProduct(image: Express.Multer.File, createProductDto: CreateProductDto): Promise<{
        data: {
            id: string;
            name: string;
            category: string;
            description: string;
            price: number;
            pointsCost: number;
            images: string[];
            stock: number;
            tagId: string | null;
            createdAt: Date;
            updatedAt: Date;
        };
        message: string;
    }>;
    updateProduct(id: string, image: Express.Multer.File, updateProductDto: UpdateProductDto): Promise<{
        data: {
            id: string;
            name: string;
            category: string;
            description: string;
            price: number;
            pointsCost: number;
            images: string[];
            stock: number;
            tagId: string | null;
            createdAt: Date;
            updatedAt: Date;
        };
        message: string;
    }>;
    deleteProduct(id: string): Promise<{
        data: {
            id: string;
            name: string;
            category: string;
            description: string;
            price: number;
            pointsCost: number;
            images: string[];
            stock: number;
            tagId: string | null;
            createdAt: Date;
            updatedAt: Date;
        };
        message: string;
    }>;
    listProducts(listProductsDto: ListProductsDto): Promise<{
        data: {
            total: number;
            page: number;
            numPerPage: number;
            data: {
                category: string;
                tag: {
                    id: string;
                    name: string;
                };
                id: string;
                name: string;
                description: string;
                price: number;
                pointsCost: number;
                images: string[];
                stock: number;
                tagId: string | null;
                createdAt: Date;
                updatedAt: Date;
            }[];
        };
        message: string;
    }>;
    redeemProduct(redeemProductDto: RedeemProductDto): Promise<{
        data: {
            id: string;
            userId: string;
            productId: string;
            merchantId: string | null;
            pointsRedeemed: number | null;
            creditRedeemed: number | null;
            collected: boolean;
            deliveryAddress: string | null;
            deliveryMethod: string;
            createdAt: Date;
            updatedAt: Date;
            courierType: string | null;
            shippingNo: string | null;
            remarks: string | null;
        };
        message: string;
    }>;
    markAsCollected(id: string, markAsCollectedDto: MarkAsCollectedDto): Promise<{
        data: {
            id: string;
            userId: string;
            productId: string;
            merchantId: string | null;
            pointsRedeemed: number | null;
            creditRedeemed: number | null;
            collected: boolean;
            deliveryAddress: string | null;
            deliveryMethod: string;
            createdAt: Date;
            updatedAt: Date;
            courierType: string | null;
            shippingNo: string | null;
            remarks: string | null;
        };
        message: string;
    }>;
    findUserRedemptionHistory(userRedemptionDto: UserRedemptionDto): Promise<{
        data: {
            totalCount: number;
            redemptionHistory: {
                productId: any;
                user: {
                    id: any;
                    email: string;
                    name: string;
                    roleId: string;
                    phoneNumber: string;
                    dateOfBirth: Date;
                    addressId: string | null;
                    profilePic: string | null;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date;
                    membershipTierId: string | null;
                    creditId: string | null;
                    loyaltyPointId: string | null;
                };
                merchant: {
                    id: string;
                    name: string;
                    image: string | null;
                    businessType: string;
                    businessRegistrationNumber: string | null;
                    contractSigneeName: string | null;
                    contractSigneeNRIC: string | null;
                    openingHours: string | null;
                    userId: string;
                    addressId: string | null;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date | null;
                    storyDescription: string | null;
                };
                product: {
                    id: string;
                    name: string;
                    category: string;
                    description: string;
                    price: number;
                    pointsCost: number;
                    images: string[];
                    stock: number;
                    tagId: string | null;
                    createdAt: Date;
                    updatedAt: Date;
                };
                id: string;
                userId: string;
                merchantId: string | null;
                pointsRedeemed: number | null;
                creditRedeemed: number | null;
                collected: boolean;
                deliveryAddress: string | null;
                deliveryMethod: string;
                createdAt: Date;
                updatedAt: Date;
                courierType: string | null;
                shippingNo: string | null;
                remarks: string | null;
            }[];
        };
        message: string;
    }>;
}
