"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MembershipController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const swagger_1 = require("@nestjs/swagger");
const user_service_1 = require("../user/user.service");
const utils_1 = require("../utils");
const membership_dto_1 = require("./membership.dto");
const membership_service_1 = require("./membership.service");
let MembershipController = class MembershipController {
    constructor(membershipService, userService) {
        this.membershipService = membershipService;
        this.userService = userService;
    }
    async findBalanceByUserId(userId) {
        const membership = await this.membershipService.getLoyaltyPointBalance(userId);
        const user = await this.userService.findOne(userId);
        if ((0, utils_1.isEmpty)(membership) && !(0, utils_1.isEmpty)(user)) {
            console.log(`Found no registered Membership User & User is active user! Registering new Membership for ${user?.name}.`);
            return { data: await this.membershipService.create(user), message: 'Find Membership Loyalty Point Balance' };
        }
        return { data: membership, message: 'Find Membership Loyalty Point Balance' };
    }
    getMembershipDetails(userId) {
        return this.membershipService.getMembershipDetails(userId);
    }
    async findCreditHistory(loyaltyPointHistoryDto) {
        const creditHistory = await this.membershipService.getUserLoyaltyPointHistory(loyaltyPointHistoryDto);
        return { data: creditHistory, message: 'Find Loyalty Point History' };
    }
    async createProduct(image, createProductDto) {
        let intake = {
            ...createProductDto,
            stock: typeof createProductDto.stock === 'string' ? parseFloat(createProductDto.stock) : createProductDto.stock,
            price: typeof createProductDto.price === 'string' ? parseFloat(createProductDto.price) : createProductDto.price,
            pointsCost: typeof createProductDto.pointsCost === 'string' ? parseFloat(createProductDto.pointsCost) : createProductDto.pointsCost,
        };
        let data = await this.membershipService.createProduct(image, intake);
        return { data: data, message: 'Create Merchandise Product' };
    }
    async updateProduct(id, image, updateProductDto) {
        let intake = {
            ...updateProductDto,
            stock: typeof updateProductDto.stock === 'string' ? parseFloat(updateProductDto.stock) : updateProductDto.stock,
            price: typeof updateProductDto.price === 'string' ? parseFloat(updateProductDto.price) : updateProductDto.price,
            pointsCost: typeof updateProductDto.pointsCost === 'string' ? parseFloat(updateProductDto.pointsCost) : updateProductDto.pointsCost,
        };
        return { data: await this.membershipService.updateProduct(id, image, intake), message: 'Update Merchandise Product' };
    }
    async deleteProduct(id) {
        const res = await this.membershipService.deleteProduct(id);
        return { data: res, message: 'Delete Merchandise Product' };
    }
    async listProducts(listProductsDto) {
        return { data: await this.membershipService.listProducts(listProductsDto), message: 'Get Merchandise Product List' };
    }
    async redeemProduct(redeemProductDto) {
        return { data: await this.membershipService.redeemProduct(redeemProductDto), message: 'Redeem Merchandise' };
    }
    async markAsCollected(id, markAsCollectedDto) {
        markAsCollectedDto.id = id;
        return { data: await this.membershipService.markAsCollected(markAsCollectedDto), message: 'Update Redempted Merchandise Product' };
    }
    async findUserRedemptionHistory(userRedemptionDto) {
        const userRedemption = await this.membershipService.getUserRedemptionHistory(userRedemptionDto);
        return { data: userRedemption, message: 'Find User Redemption History' };
    }
};
exports.MembershipController = MembershipController;
__decorate([
    (0, common_1.Get)('/point/:id'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], MembershipController.prototype, "findBalanceByUserId", null);
__decorate([
    (0, common_1.Get)(':userId'),
    __param(0, (0, common_1.Param)('userId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], MembershipController.prototype, "getMembershipDetails", null);
__decorate([
    (0, common_1.Post)('/point/history'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [membership_dto_1.LoyaltyPointHistoryDto]),
    __metadata("design:returntype", Promise)
], MembershipController.prototype, "findCreditHistory", null);
__decorate([
    (0, common_1.Post)('/merchandise/create'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('imagefile', { limits: { fileSize: 5 * 1024 * 1024 } })),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, membership_dto_1.CreateProductDto]),
    __metadata("design:returntype", Promise)
], MembershipController.prototype, "createProduct", null);
__decorate([
    (0, common_1.Put)('/merchandise/update/:id'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('imagefile')),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.UploadedFile)()),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object, membership_dto_1.UpdateProductDto]),
    __metadata("design:returntype", Promise)
], MembershipController.prototype, "updateProduct", null);
__decorate([
    (0, common_1.Delete)('/merchandise/delete/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], MembershipController.prototype, "deleteProduct", null);
__decorate([
    (0, common_1.Post)('/merchandise/list'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [membership_dto_1.ListProductsDto]),
    __metadata("design:returntype", Promise)
], MembershipController.prototype, "listProducts", null);
__decorate([
    (0, common_1.Post)('/merchandise/redeem'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [membership_dto_1.RedeemProductDto]),
    __metadata("design:returntype", Promise)
], MembershipController.prototype, "redeemProduct", null);
__decorate([
    (0, common_1.Put)('/merchandise/collect/:id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, membership_dto_1.MarkAsCollectedDto]),
    __metadata("design:returntype", Promise)
], MembershipController.prototype, "markAsCollected", null);
__decorate([
    (0, common_1.Post)('/merchandise/user-redemption'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [membership_dto_1.UserRedemptionDto]),
    __metadata("design:returntype", Promise)
], MembershipController.prototype, "findUserRedemptionHistory", null);
exports.MembershipController = MembershipController = __decorate([
    (0, swagger_1.ApiTags)('Membership'),
    (0, common_1.Controller)('membership'),
    __metadata("design:paramtypes", [membership_service_1.MembershipService,
        user_service_1.UserService])
], MembershipController);
//# sourceMappingURL=membership.controller.js.map