export declare enum TransactionType {
    PURCHASE = "PURCHASE",
    LOYALTY_POINT = "LOYALTY_POINT",
    EARNED = "EARNED",
    REFUND = "REFUND",
    REFUNDED = "REFUNDED",
    REDEMPTION = "REDEMPTION"
}
export declare enum DeliveryMethod {
    DELIVERY = "DELIVERY",
    PICKUP = "PICKUP",
    REDEEM_AT_STORE = "REDEEM_AT_STORE"
}
export declare class LoyaltyPointHistoryDto {
    userId: string;
    page?: number;
    numPerPage?: number;
    orderBy?: string;
    startDate?: string;
    endDate?: string;
}
export declare class CreateProductDto {
    name: string;
    category: string;
    description: string;
    price: string;
    pointsCost: string;
    images: string[];
    stock: string;
    tagId?: string;
}
export declare class UpdateProductDto {
    name?: string;
    description?: string;
    price?: string;
    pointsCost?: string;
    images?: string[];
    stock?: string;
    tagId?: string;
}
export declare class RedeemProductDto {
    userId: string;
    productId: string;
    paymentMethod: TransactionType;
    deliveryMethod: DeliveryMethod;
    deliveryAddress?: string;
    merchantId?: string;
}
export declare class MarkAsCollectedDto {
    id: string;
    courierType?: string;
    shippingNo?: string;
    remarks?: string;
    collected?: boolean;
}
export declare class ListProductsDto {
    page?: number;
    numPerPage?: number;
    category?: string;
    search?: string;
    sortOrder?: 'asc' | 'desc';
    sortBy?: 'price' | 'createdAt';
}
export declare class UserRedemptionDto {
    userId: string;
    page?: number;
    numPerPage?: number;
    orderBy?: string;
    startDate?: string;
    endDate?: string;
}
