"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRedemptionDto = exports.ListProductsDto = exports.MarkAsCollectedDto = exports.RedeemProductDto = exports.UpdateProductDto = exports.CreateProductDto = exports.LoyaltyPointHistoryDto = exports.DeliveryMethod = exports.TransactionType = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
var TransactionType;
(function (TransactionType) {
    TransactionType["PURCHASE"] = "PURCHASE";
    TransactionType["LOYALTY_POINT"] = "LOYALTY_POINT";
    TransactionType["EARNED"] = "EARNED";
    TransactionType["REFUND"] = "REFUND";
    TransactionType["REFUNDED"] = "REFUNDED";
    TransactionType["REDEMPTION"] = "REDEMPTION";
})(TransactionType || (exports.TransactionType = TransactionType = {}));
var DeliveryMethod;
(function (DeliveryMethod) {
    DeliveryMethod["DELIVERY"] = "DELIVERY";
    DeliveryMethod["PICKUP"] = "PICKUP";
    DeliveryMethod["REDEEM_AT_STORE"] = "REDEEM_AT_STORE";
})(DeliveryMethod || (exports.DeliveryMethod = DeliveryMethod = {}));
class LoyaltyPointHistoryDto {
    constructor() {
        this.page = 1;
        this.numPerPage = 5;
        this.orderBy = 'desc';
    }
}
exports.LoyaltyPointHistoryDto = LoyaltyPointHistoryDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], LoyaltyPointHistoryDto.prototype, "userId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", Number)
], LoyaltyPointHistoryDto.prototype, "page", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", Number)
], LoyaltyPointHistoryDto.prototype, "numPerPage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false, enum: ['asc', 'desc'], default: 'desc' }),
    __metadata("design:type", String)
], LoyaltyPointHistoryDto.prototype, "orderBy", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], LoyaltyPointHistoryDto.prototype, "startDate", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], LoyaltyPointHistoryDto.prototype, "endDate", void 0);
class CreateProductDto {
}
exports.CreateProductDto = CreateProductDto;
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "category", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "price", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "pointsCost", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", Array)
], CreateProductDto.prototype, "images", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: String }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "stock", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], CreateProductDto.prototype, "tagId", void 0);
class UpdateProductDto {
}
exports.UpdateProductDto = UpdateProductDto;
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], UpdateProductDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], UpdateProductDto.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], UpdateProductDto.prototype, "price", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], UpdateProductDto.prototype, "pointsCost", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ type: [String], required: false }),
    __metadata("design:type", Array)
], UpdateProductDto.prototype, "images", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], UpdateProductDto.prototype, "stock", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], UpdateProductDto.prototype, "tagId", void 0);
class RedeemProductDto {
    constructor() {
        this.paymentMethod = TransactionType.LOYALTY_POINT;
        this.deliveryMethod = DeliveryMethod.DELIVERY;
    }
}
exports.RedeemProductDto = RedeemProductDto;
__decorate([
    (0, swagger_1.ApiProperty)({ required: true }),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], RedeemProductDto.prototype, "userId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: true }),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], RedeemProductDto.prototype, "productId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: TransactionType }),
    __metadata("design:type", String)
], RedeemProductDto.prototype, "paymentMethod", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ enum: DeliveryMethod }),
    __metadata("design:type", String)
], RedeemProductDto.prototype, "deliveryMethod", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], RedeemProductDto.prototype, "deliveryAddress", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], RedeemProductDto.prototype, "merchantId", void 0);
class MarkAsCollectedDto {
}
exports.MarkAsCollectedDto = MarkAsCollectedDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], MarkAsCollectedDto.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], MarkAsCollectedDto.prototype, "courierType", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], MarkAsCollectedDto.prototype, "shippingNo", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], MarkAsCollectedDto.prototype, "remarks", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", Boolean)
], MarkAsCollectedDto.prototype, "collected", void 0);
class ListProductsDto {
    constructor() {
        this.page = 1;
        this.numPerPage = 10;
        this.sortOrder = 'desc';
        this.sortBy = 'createdAt';
    }
}
exports.ListProductsDto = ListProductsDto;
__decorate([
    (0, swagger_1.ApiProperty)({ required: false, default: 1 }),
    __metadata("design:type", Number)
], ListProductsDto.prototype, "page", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false, default: 10 }),
    __metadata("design:type", Number)
], ListProductsDto.prototype, "numPerPage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], ListProductsDto.prototype, "category", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], ListProductsDto.prototype, "search", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false, enum: ['asc', 'desc'], default: 'desc' }),
    __metadata("design:type", String)
], ListProductsDto.prototype, "sortOrder", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false, enum: ['price', 'createdAt'], default: 'createdAt' }),
    __metadata("design:type", String)
], ListProductsDto.prototype, "sortBy", void 0);
class UserRedemptionDto {
    constructor() {
        this.page = 1;
        this.numPerPage = 5;
        this.orderBy = 'desc';
    }
}
exports.UserRedemptionDto = UserRedemptionDto;
__decorate([
    (0, swagger_1.ApiProperty)(),
    __metadata("design:type", String)
], UserRedemptionDto.prototype, "userId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", Number)
], UserRedemptionDto.prototype, "page", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", Number)
], UserRedemptionDto.prototype, "numPerPage", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false, enum: ['asc', 'desc'], default: 'desc' }),
    __metadata("design:type", String)
], UserRedemptionDto.prototype, "orderBy", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], UserRedemptionDto.prototype, "startDate", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ required: false }),
    __metadata("design:type", String)
], UserRedemptionDto.prototype, "endDate", void 0);
//# sourceMappingURL=membership.dto.js.map