import { User } from '@prisma/client';
import { ListProductsDto, LoyaltyPointHistoryDto, MarkAsCollectedDto, RedeemProductDto, UserRedemptionDto } from './membership.dto';
export declare class MembershipService {
    markAsCollected(markAsCollectedDto: MarkAsCollectedDto): Promise<{
        id: string;
        userId: string;
        productId: string;
        merchantId: string | null;
        pointsRedeemed: number | null;
        creditRedeemed: number | null;
        collected: boolean;
        deliveryAddress: string | null;
        deliveryMethod: string;
        createdAt: Date;
        updatedAt: Date;
        courierType: string | null;
        shippingNo: string | null;
        remarks: string | null;
    }>;
    getUserLoyaltyPointHistory(loyaltyPointHistoryDto: LoyaltyPointHistoryDto): Promise<{
        loyaltyPointHistory: {
            history: {
                id: string;
                userId: string;
                amount: number;
                newTotal: number;
                type: string;
                orderId: string | null;
                createdAt: Date;
                updatedAt: Date | null;
                lastLoyaltyPointAmount: number | null;
                loyaltyPointId: string | null;
            }[];
        } & {
            id: string;
            balance: number;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        totalCount: number;
    }>;
    getMembershipDetails(userId: string): Promise<{
        id: string;
        balance: number;
        userId: string;
        createdAt: Date;
        updatedAt: Date | null;
    }>;
    create(user: User): Promise<{
        loyaltyPoint: {
            history: {
                id: string;
                userId: string;
                amount: number;
                newTotal: number;
                type: string;
                orderId: string | null;
                createdAt: Date;
                updatedAt: Date | null;
                lastLoyaltyPointAmount: number | null;
                loyaltyPointId: string | null;
            }[];
        } & {
            id: string;
            balance: number;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        membershipTier: {
            id: string;
            name: string;
            pointsRequired: number;
            pointsMultiplier: number;
        };
        name: string;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
    }>;
    getLoyaltyPointBalance(userId: string): Promise<{
        loyaltyPoint: {
            history: {
                id: string;
                userId: string;
                amount: number;
                newTotal: number;
                type: string;
                orderId: string | null;
                createdAt: Date;
                updatedAt: Date | null;
                lastLoyaltyPointAmount: number | null;
                loyaltyPointId: string | null;
            }[];
        } & {
            id: string;
            balance: number;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        membershipTier: {
            id: string;
            name: string;
            pointsRequired: number;
            pointsMultiplier: number;
        };
        name: string;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
    }>;
    addLoyaltyPoints(userId: string, points: number, type?: string, orderId?: string): Promise<void>;
    createProduct(file: Express.Multer.File, data: {
        name: string;
        category: string;
        description: string;
        price: number;
        pointsCost: number;
        images: string[];
        stock: number;
        tagId?: string;
    }): Promise<{
        id: string;
        name: string;
        category: string;
        description: string;
        price: number;
        pointsCost: number;
        images: string[];
        stock: number;
        tagId: string | null;
        createdAt: Date;
        updatedAt: Date;
    }>;
    updateProduct(id: string, file: Express.Multer.File, data: {
        name?: string;
        description?: string;
        price?: number;
        pointsCost?: number;
        images?: string[];
        stock?: number;
        tagId?: string;
    }): Promise<{
        id: string;
        name: string;
        category: string;
        description: string;
        price: number;
        pointsCost: number;
        images: string[];
        stock: number;
        tagId: string | null;
        createdAt: Date;
        updatedAt: Date;
    }>;
    deleteProduct(id: string): Promise<{
        id: string;
        name: string;
        category: string;
        description: string;
        price: number;
        pointsCost: number;
        images: string[];
        stock: number;
        tagId: string | null;
        createdAt: Date;
        updatedAt: Date;
    }>;
    listProducts(listProductsDto: ListProductsDto): Promise<{
        total: number;
        page: number;
        numPerPage: number;
        data: {
            category: string;
            tag: {
                id: string;
                name: string;
            };
            id: string;
            name: string;
            description: string;
            price: number;
            pointsCost: number;
            images: string[];
            stock: number;
            tagId: string | null;
            createdAt: Date;
            updatedAt: Date;
        }[];
    }>;
    redeemProduct(redeemProduct: RedeemProductDto): Promise<{
        id: string;
        userId: string;
        productId: string;
        merchantId: string | null;
        pointsRedeemed: number | null;
        creditRedeemed: number | null;
        collected: boolean;
        deliveryAddress: string | null;
        deliveryMethod: string;
        createdAt: Date;
        updatedAt: Date;
        courierType: string | null;
        shippingNo: string | null;
        remarks: string | null;
    }>;
    getUserRedemptionHistory(userRedemptionDto: UserRedemptionDto): Promise<{
        totalCount: number;
        redemptionHistory: {
            productId: any;
            user: {
                id: any;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
            merchant: {
                id: string;
                name: string;
                image: string | null;
                businessType: string;
                businessRegistrationNumber: string | null;
                contractSigneeName: string | null;
                contractSigneeNRIC: string | null;
                openingHours: string | null;
                userId: string;
                addressId: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date | null;
                storyDescription: string | null;
            };
            product: {
                id: string;
                name: string;
                category: string;
                description: string;
                price: number;
                pointsCost: number;
                images: string[];
                stock: number;
                tagId: string | null;
                createdAt: Date;
                updatedAt: Date;
            };
            id: string;
            userId: string;
            merchantId: string | null;
            pointsRedeemed: number | null;
            creditRedeemed: number | null;
            collected: boolean;
            deliveryAddress: string | null;
            deliveryMethod: string;
            createdAt: Date;
            updatedAt: Date;
            courierType: string | null;
            shippingNo: string | null;
            remarks: string | null;
        }[];
    }>;
}
