"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MembershipService = void 0;
const common_1 = require("@nestjs/common");
const utils_1 = require("../utils");
const prisma_1 = require("../prisma");
const membership_dto_1 = require("./membership.dto");
const UploadFunction = new utils_1.UploadImg();
let MembershipService = class MembershipService {
    async markAsCollected(markAsCollectedDto) {
        const { id, courierType, shippingNo, remarks, collected } = markAsCollectedDto;
        const redemption = await prisma_1.default.userRedemptionHistory.findUnique({
            where: { id },
        });
        if (!redemption) {
            throw new common_1.NotFoundException({
                error: 'Redemption not found. Please try again later.',
                message: ['Redemption not found. Please try again later.'],
                statusCode: 500
            });
        }
        return await prisma_1.default.userRedemptionHistory.update({
            where: { id },
            data: {
                collected,
                courierType,
                shippingNo,
                remarks,
            },
        });
    }
    async getUserLoyaltyPointHistory(loyaltyPointHistoryDto) {
        const whereClause = {};
        if (loyaltyPointHistoryDto.startDate) {
            whereClause.createdAt = {
                ...whereClause.createdAt,
                gte: new Date(loyaltyPointHistoryDto.startDate),
            };
        }
        if (loyaltyPointHistoryDto.endDate) {
            whereClause.createdAt = {
                ...whereClause.createdAt,
                lte: new Date(loyaltyPointHistoryDto.endDate),
            };
        }
        const loyaltyPointHistory = await prisma_1.default.loyaltyPoint.findUnique({
            where: {
                userId: loyaltyPointHistoryDto.userId,
            },
            include: {
                history: {
                    where: whereClause,
                    orderBy: {
                        createdAt: loyaltyPointHistoryDto.orderBy,
                    },
                    skip: (loyaltyPointHistoryDto.page - 1) * loyaltyPointHistoryDto.numPerPage,
                    take: loyaltyPointHistoryDto.numPerPage,
                },
            },
        });
        const totalCount = await prisma_1.default.loyaltyPointHistory.count({
            where: {
                loyaltyPointId: loyaltyPointHistory.id,
                ...whereClause,
            },
        });
        return {
            loyaltyPointHistory,
            totalCount,
        };
    }
    async getMembershipDetails(userId) {
        const membership = await prisma_1.default.loyaltyPoint.findUnique({
            where: { userId: userId }
        });
        if (!membership) {
            throw new common_1.NotFoundException({
                error: 'User not found. Please try again later.',
                message: ['User not found. Please try again later.'],
                statusCode: 500
            });
        }
        return membership;
    }
    async create(user) {
        const newMembership = await prisma_1.default.loyaltyPoint.create({
            data: {
                balance: 0.00,
                userId: user.id,
                createdAt: new Date(),
                user: { connect: { id: user.id } },
            },
        });
        await prisma_1.default.user.update({
            where: { id: user.id },
            data: { loyaltyPointId: newMembership.id },
        });
        return await this.getLoyaltyPointBalance(user.id);
    }
    async getLoyaltyPointBalance(userId) {
        const user = await prisma_1.default.user.findFirst({
            where: { id: userId },
            include: {
                loyaltyPoint: {
                    include: {
                        history: {
                            orderBy: {
                                createdAt: 'desc',
                            },
                            take: 5,
                        }
                    }
                },
                membershipTier: true
            }
        });
        const { id, email, phoneNumber, dateOfBirth, addressId, profilePic, roleId, creditId, loyaltyPointId, ...newStructure } = user;
        return newStructure;
    }
    async addLoyaltyPoints(userId, points, type = membership_dto_1.TransactionType.PURCHASE, orderId) {
        const user = await prisma_1.default.user.findUnique({
            where: { id: userId },
            include: { loyaltyPoint: true },
        });
        if (!user || !user.loyaltyPoint) {
            throw new common_1.InternalServerErrorException({
                error: 'User or loyalty points not found. Please try again later.',
                message: ['User or loyalty points not found. Please try again later.'],
                statusCode: 500
            });
        }
        const newBalance = user.loyaltyPoint.balance + points;
        await prisma_1.default.loyaltyPoint.update({
            where: { userId: userId },
            data: { balance: newBalance },
        });
        await prisma_1.default.loyaltyPointHistory.create({
            data: {
                userId: userId,
                amount: points,
                newTotal: newBalance,
                lastLoyaltyPointAmount: user.loyaltyPoint.balance,
                type: type,
                orderId: orderId,
                loyaltyPointId: user.loyaltyPoint.id,
                createdAt: new Date(),
                updatedAt: new Date()
            },
        });
    }
    async createProduct(file, data) {
        try {
            const res = await prisma_1.default.merchandiseProduct.create({
                data,
            });
            const publicUrl = await UploadFunction.uploadimage("loyalty_merchant_img", res.id, file);
            const updatedImages = [publicUrl.data.publicUrl];
            return await prisma_1.default.merchandiseProduct.update({
                where: {
                    id: res.id
                },
                data: {
                    images: updatedImages
                }
            });
        }
        catch (error) {
            throw (error);
        }
    }
    async updateProduct(id, file, data) {
        try {
            if (!(0, utils_1.isEmpty)(file)) {
                const publicUrl = await UploadFunction.uploadimage("loyalty_merchant_img", id, file);
                let updatedImages = [publicUrl.data.publicUrl];
                data.images = updatedImages;
            }
            return await prisma_1.default.merchandiseProduct.update({
                where: { id },
                data,
            });
        }
        catch (error) {
            throw (error);
        }
    }
    async deleteProduct(id) {
        try {
            return await prisma_1.default.merchandiseProduct.delete({
                where: { id },
            });
        }
        catch (error) {
            throw (error);
        }
    }
    async listProducts(listProductsDto) {
        const page = listProductsDto.page;
        const numPerPage = listProductsDto.numPerPage;
        const skip = (page - 1) * numPerPage;
        const [products, total] = await Promise.all([
            prisma_1.default.merchandiseProduct.findMany({
                skip,
                take: numPerPage,
                include: {
                    tag: true,
                },
                orderBy: {
                    createdAt: 'desc',
                },
            }),
            prisma_1.default.merchandiseProduct.count(),
        ]);
        return {
            total,
            page,
            numPerPage,
            data: products.map(product => ({
                ...product,
                category: product.category,
            })),
        };
    }
    async redeemProduct(redeemProduct) {
        if (!redeemProduct.paymentMethod) {
            redeemProduct.paymentMethod = membership_dto_1.TransactionType.LOYALTY_POINT;
        }
        const user = await prisma_1.default.user.findUnique({
            where: { id: redeemProduct.userId },
            include: {
                loyaltyPoint: true,
                credit: true,
            },
        });
        const product = await prisma_1.default.merchandiseProduct.findUnique({
            where: { id: redeemProduct.productId },
        });
        if (!user || !product) {
            throw new common_1.InternalServerErrorException({
                error: 'Product or User not found. Please try again later.',
                message: ['Product or User not found. Please try again later.'],
                statusCode: 500
            });
        }
        if (product.stock <= 0) {
            throw new common_1.InternalServerErrorException({
                error: 'Product out of stock. Please try again later.',
                message: ['Product out of stock. Please try again later.'],
                statusCode: 500
            });
        }
        if (redeemProduct.paymentMethod === membership_dto_1.TransactionType.LOYALTY_POINT) {
            if (user.loyaltyPoint.balance < product.pointsCost) {
                throw new common_1.InternalServerErrorException({
                    error: 'Insufficient points',
                    message: ['You do not have enough points to redeem this gift.'],
                    statusCode: 500
                });
            }
            const updatedLP = await prisma_1.default.loyaltyPoint.update({
                where: { userId: redeemProduct.userId },
                data: {
                    balance: {
                        decrement: product.pointsCost,
                    },
                },
            });
            await prisma_1.default.loyaltyPointHistory.create({
                data: {
                    userId: redeemProduct.userId,
                    amount: -product.pointsCost,
                    newTotal: updatedLP.balance,
                    lastLoyaltyPointAmount: user.loyaltyPoint.balance,
                    type: membership_dto_1.TransactionType.REDEMPTION,
                    loyaltyPointId: user.loyaltyPoint.id,
                    createdAt: new Date(),
                    updatedAt: new Date(),
                },
            });
        }
        else {
            throw new common_1.InternalServerErrorException({
                error: 'Invalid Payment Method. Please try again later.',
                message: ['Invalid Payment Method. Please try again later.'],
                statusCode: 500
            });
        }
        await prisma_1.default.merchandiseProduct.update({
            where: { id: redeemProduct.productId },
            data: {
                stock: {
                    decrement: 1,
                },
            },
        });
        return prisma_1.default.userRedemptionHistory.create({
            data: {
                userId: redeemProduct.userId,
                productId: redeemProduct.productId,
                pointsRedeemed: redeemProduct.paymentMethod === membership_dto_1.TransactionType.LOYALTY_POINT ? product.pointsCost : null,
                deliveryMethod: redeemProduct.deliveryMethod,
                deliveryAddress: redeemProduct.deliveryAddress,
                merchantId: redeemProduct.deliveryMethod === membership_dto_1.DeliveryMethod.REDEEM_AT_STORE ? redeemProduct.merchantId : null,
            },
        });
    }
    async getUserRedemptionHistory(userRedemptionDto) {
        const whereClause = { userId: userRedemptionDto.userId };
        if (userRedemptionDto.startDate) {
            whereClause.createdAt = {
                ...whereClause.createdAt,
                gte: new Date(userRedemptionDto.startDate),
            };
        }
        if (userRedemptionDto.endDate) {
            whereClause.createdAt = {
                ...whereClause.createdAt,
                lte: new Date(userRedemptionDto.endDate),
            };
        }
        const res = await prisma_1.default.userRedemptionHistory.findMany({
            where: whereClause,
            orderBy: {
                createdAt: userRedemptionDto.orderBy,
            },
            skip: (userRedemptionDto.page - 1) * userRedemptionDto.numPerPage,
            take: userRedemptionDto.numPerPage,
            include: {
                product: true,
                merchant: true,
                user: true,
            },
        });
        const sanitizedRes = res.map(item => {
            return {
                ...item,
                productId: undefined,
                user: {
                    ...item.user,
                    id: undefined,
                },
            };
        });
        const totalCount = await prisma_1.default.userRedemptionHistory.count({
            where: whereClause,
        });
        return {
            totalCount,
            redemptionHistory: sanitizedRes,
        };
    }
};
exports.MembershipService = MembershipService;
exports.MembershipService = MembershipService = __decorate([
    (0, common_1.Injectable)()
], MembershipService);
//# sourceMappingURL=membership.service.js.map