import { CheckMenuAvailabilityDto, CreateMenuDto, UpdateMenuDto, MenuImgUploadDto } from './menu.dto';
import { MenuService } from './menu.service';
export declare class MenuController {
    private menuService;
    constructor(menuService: MenuService);
    findAll(): Promise<{
        data: ({
            menuOption: ({
                option: {
                    id: string;
                    name: string;
                    price: number;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date | null;
                    menuOptionId: string;
                }[];
            } & {
                id: string;
                name: string;
                isRequired: boolean;
                min: number;
                max: number;
                active: boolean;
                menuId: string;
            })[];
        } & {
            id: string;
            name: string;
            image: string | null;
            basePrice: number;
            description: string;
            createdAt: Date;
            updatedAt: Date | null;
            active: boolean;
            category: string;
            merchantId: string;
        })[];
        message: string;
    }>;
    findOne(id: string): Promise<{
        data: {
            menuOption: ({
                option: {
                    id: string;
                    name: string;
                    price: number;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date | null;
                    menuOptionId: string;
                }[];
            } & {
                id: string;
                name: string;
                isRequired: boolean;
                min: number;
                max: number;
                active: boolean;
                menuId: string;
            })[];
        } & {
            id: string;
            name: string;
            image: string | null;
            basePrice: number;
            description: string;
            createdAt: Date;
            updatedAt: Date | null;
            active: boolean;
            category: string;
            merchantId: string;
        };
        message: string;
    }>;
    findAllBasedOnMerchant(id: string): {
        data: Promise<({
            menuOption: ({
                option: {
                    id: string;
                    name: string;
                    price: number;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date | null;
                    menuOptionId: string;
                }[];
            } & {
                id: string;
                name: string;
                isRequired: boolean;
                min: number;
                max: number;
                active: boolean;
                menuId: string;
            })[];
        } & {
            id: string;
            name: string;
            image: string | null;
            basePrice: number;
            description: string;
            createdAt: Date;
            updatedAt: Date | null;
            active: boolean;
            category: string;
            merchantId: string;
        })[]>;
        message: string;
    };
    create(image: Express.Multer.File, reqData: CreateMenuDto): Promise<{
        data: {
            menuOption: ({
                option: {
                    id: string;
                    name: string;
                    price: number;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date | null;
                    menuOptionId: string;
                }[];
            } & {
                id: string;
                name: string;
                isRequired: boolean;
                min: number;
                max: number;
                active: boolean;
                menuId: string;
            })[];
        } & {
            id: string;
            name: string;
            image: string | null;
            basePrice: number;
            description: string;
            createdAt: Date;
            updatedAt: Date | null;
            active: boolean;
            category: string;
            merchantId: string;
        };
        message: string;
    }>;
    uploadMenuImg(imagefile: Express.Multer.File, reqData: MenuImgUploadDto): Promise<{
        data: string;
        message: string;
    }>;
    checkMenuAvailability(reqData: CheckMenuAvailabilityDto): Promise<{
        data: ({
            menuOption: ({
                option: {
                    id: string;
                    name: string;
                    price: number;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date | null;
                    menuOptionId: string;
                }[];
            } & {
                id: string;
                name: string;
                isRequired: boolean;
                min: number;
                max: number;
                active: boolean;
                menuId: string;
            })[];
        } & {
            id: string;
            name: string;
            image: string | null;
            basePrice: number;
            description: string;
            createdAt: Date;
            updatedAt: Date | null;
            active: boolean;
            category: string;
            merchantId: string;
        })[];
        message: string;
    }>;
    update(id: string, reqData: UpdateMenuDto): Promise<{
        data: {
            menuOption: ({
                option: {
                    id: string;
                    name: string;
                    price: number;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date | null;
                    menuOptionId: string;
                }[];
            } & {
                id: string;
                name: string;
                isRequired: boolean;
                min: number;
                max: number;
                active: boolean;
                menuId: string;
            })[];
        } & {
            id: string;
            name: string;
            image: string | null;
            basePrice: number;
            description: string;
            createdAt: Date;
            updatedAt: Date | null;
            active: boolean;
            category: string;
            merchantId: string;
        };
        message: string;
    }>;
    remove(id: string): Promise<{
        data: {
            menuOption: ({
                option: {
                    id: string;
                    name: string;
                    price: number;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date | null;
                    menuOptionId: string;
                }[];
            } & {
                id: string;
                name: string;
                isRequired: boolean;
                min: number;
                max: number;
                active: boolean;
                menuId: string;
            })[];
        } & {
            id: string;
            name: string;
            image: string | null;
            basePrice: number;
            description: string;
            createdAt: Date;
            updatedAt: Date | null;
            active: boolean;
            category: string;
            merchantId: string;
        };
        message: string;
    }>;
}
