import { CheckMenuAvailabilityDto, CreateMenuDto, UpdateMenuDto, MenuImgUploadDto } from './menu.dto';
export declare class MenuService {
    constructor();
    create(file: Express.Multer.File, data: CreateMenuDto): Promise<{
        menuOption: ({
            option: {
                id: string;
                name: string;
                price: number;
                active: boolean;
                createdAt: Date;
                updatedAt: Date | null;
                menuOptionId: string;
            }[];
        } & {
            id: string;
            name: string;
            isRequired: boolean;
            min: number;
            max: number;
            active: boolean;
            menuId: string;
        })[];
    } & {
        id: string;
        name: string;
        image: string | null;
        basePrice: number;
        description: string;
        createdAt: Date;
        updatedAt: Date | null;
        active: boolean;
        category: string;
        merchantId: string;
    }>;
    findAll(): Promise<({
        menuOption: ({
            option: {
                id: string;
                name: string;
                price: number;
                active: boolean;
                createdAt: Date;
                updatedAt: Date | null;
                menuOptionId: string;
            }[];
        } & {
            id: string;
            name: string;
            isRequired: boolean;
            min: number;
            max: number;
            active: boolean;
            menuId: string;
        })[];
    } & {
        id: string;
        name: string;
        image: string | null;
        basePrice: number;
        description: string;
        createdAt: Date;
        updatedAt: Date | null;
        active: boolean;
        category: string;
        merchantId: string;
    })[]>;
    findAllByMerchant(merchantId: string): Promise<({
        menuOption: ({
            option: {
                id: string;
                name: string;
                price: number;
                active: boolean;
                createdAt: Date;
                updatedAt: Date | null;
                menuOptionId: string;
            }[];
        } & {
            id: string;
            name: string;
            isRequired: boolean;
            min: number;
            max: number;
            active: boolean;
            menuId: string;
        })[];
    } & {
        id: string;
        name: string;
        image: string | null;
        basePrice: number;
        description: string;
        createdAt: Date;
        updatedAt: Date | null;
        active: boolean;
        category: string;
        merchantId: string;
    })[]>;
    findOne(id: string): Promise<{
        menuOption: ({
            option: {
                id: string;
                name: string;
                price: number;
                active: boolean;
                createdAt: Date;
                updatedAt: Date | null;
                menuOptionId: string;
            }[];
        } & {
            id: string;
            name: string;
            isRequired: boolean;
            min: number;
            max: number;
            active: boolean;
            menuId: string;
        })[];
    } & {
        id: string;
        name: string;
        image: string | null;
        basePrice: number;
        description: string;
        createdAt: Date;
        updatedAt: Date | null;
        active: boolean;
        category: string;
        merchantId: string;
    }>;
    findMenu(data: CheckMenuAvailabilityDto): Promise<({
        menuOption: ({
            option: {
                id: string;
                name: string;
                price: number;
                active: boolean;
                createdAt: Date;
                updatedAt: Date | null;
                menuOptionId: string;
            }[];
        } & {
            id: string;
            name: string;
            isRequired: boolean;
            min: number;
            max: number;
            active: boolean;
            menuId: string;
        })[];
    } & {
        id: string;
        name: string;
        image: string | null;
        basePrice: number;
        description: string;
        createdAt: Date;
        updatedAt: Date | null;
        active: boolean;
        category: string;
        merchantId: string;
    })[]>;
    update(id: string, data: UpdateMenuDto): Promise<{
        menuOption: ({
            option: {
                id: string;
                name: string;
                price: number;
                active: boolean;
                createdAt: Date;
                updatedAt: Date | null;
                menuOptionId: string;
            }[];
        } & {
            id: string;
            name: string;
            isRequired: boolean;
            min: number;
            max: number;
            active: boolean;
            menuId: string;
        })[];
    } & {
        id: string;
        name: string;
        image: string | null;
        basePrice: number;
        description: string;
        createdAt: Date;
        updatedAt: Date | null;
        active: boolean;
        category: string;
        merchantId: string;
    }>;
    remove(id: string): Promise<{
        menuOption: ({
            option: {
                id: string;
                name: string;
                price: number;
                active: boolean;
                createdAt: Date;
                updatedAt: Date | null;
                menuOptionId: string;
            }[];
        } & {
            id: string;
            name: string;
            isRequired: boolean;
            min: number;
            max: number;
            active: boolean;
            menuId: string;
        })[];
    } & {
        id: string;
        name: string;
        image: string | null;
        basePrice: number;
        description: string;
        createdAt: Date;
        updatedAt: Date | null;
        active: boolean;
        category: string;
        merchantId: string;
    }>;
    uploadMenuImage(file: Express.Multer.File, data: MenuImgUploadDto): Promise<string>;
}
