"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuService = void 0;
const common_1 = require("@nestjs/common");
const prisma_1 = require("../prisma");
const utils_1 = require("../utils");
const UploadFunction = new utils_1.UploadImg();
let MenuService = class MenuService {
    constructor() { }
    async create(file, data) {
        const menuoption = JSON.parse(data.menuOption);
        const menu = await prisma_1.default.menu.create({
            data: {
                name: data.name,
                basePrice: parseFloat(data.basePrice),
                category: data.category,
                description: data.description,
                merchantId: data.merchantId,
                active: data.active,
                image: "",
                menuOption: {
                    create: menuoption.map((menuOption) => ({
                        name: menuOption.name,
                        isRequired: menuOption.isRequired,
                        min: menuOption.min,
                        max: menuOption.max,
                        active: menuOption.active,
                        option: {
                            create: menuOption.option.map((opt) => ({
                                name: opt.name,
                                price: opt.price,
                                active: opt.active,
                            })),
                        },
                    })),
                },
            },
        });
        const publicurl = await UploadFunction.uploadimage("menuimg", menu.id, file);
        const updatedMenu = await prisma_1.default.menu.update({
            where: { id: menu.id },
            data: {
                image: publicurl.data.publicUrl,
            },
            include: {
                menuOption: {
                    include: {
                        option: true,
                    },
                },
            },
        });
        return updatedMenu;
    }
    async findAll() {
        return await prisma_1.default.menu.findMany({
            include: {
                menuOption: {
                    include: {
                        option: true
                    }
                }
            }
        });
    }
    async findAllByMerchant(merchantId) {
        return prisma_1.default.menu.findMany({
            where: { merchantId },
            include: {
                menuOption: {
                    include: {
                        option: true
                    }
                }
            },
        });
    }
    async findOne(id) {
        return prisma_1.default.menu.findUnique({
            where: { id },
            include: {
                menuOption: {
                    include: {
                        option: true
                    }
                }
            },
        });
    }
    async findMenu(data) {
        return prisma_1.default.menu.findMany({
            where: {
                id: {
                    in: data.menuIds
                }
            },
            include: {
                menuOption: {
                    include: {
                        option: true
                    }
                }
            },
        });
    }
    async update(id, data) {
        for (const menuOption of data.menuOption) {
            var menuoptionid = "";
            if (menuOption.id) {
                await prisma_1.default.menuOption.update({
                    where: { id: menuOption.id },
                    data: {
                        name: menuOption.name,
                        isRequired: menuOption.isRequired,
                        min: menuOption.min,
                        max: menuOption.max,
                        active: menuOption.active
                    },
                });
                menuoptionid = menuOption.id;
            }
            else {
                const menuoption = await prisma_1.default.menuOption.create({
                    data: {
                        name: menuOption.name,
                        isRequired: menuOption.isRequired,
                        min: menuOption.min,
                        max: menuOption.max,
                        ...(menuOption.active && {
                            active: menuOption.active
                        }),
                        menu: {
                            connect: {
                                id: id,
                            },
                        },
                    },
                });
                menuoptionid = menuoption.id;
            }
            for (const option of menuOption.option) {
                if (option.id) {
                    await prisma_1.default.option.update({
                        where: { id: option.id },
                        data: {
                            name: option.name,
                            price: option.price,
                            active: option.active
                        },
                    });
                }
                else {
                    await prisma_1.default.option.create({
                        data: {
                            name: option.name,
                            price: option.price,
                            ...(option.active && {
                                active: option.active
                            }),
                            menuOption: {
                                connect: {
                                    id: menuoptionid,
                                },
                            },
                        },
                    });
                }
            }
        }
        const updatedMenu = await prisma_1.default.menu.update({
            where: { id },
            data: {
                name: data.name,
                basePrice: data.basePrice,
                description: data.description,
                active: data.active,
                category: data.category,
                merchantId: data.merchantId,
            },
            include: {
                menuOption: {
                    include: {
                        option: true,
                    },
                },
            },
        });
        return updatedMenu;
    }
    async remove(id) {
        return prisma_1.default.menu.delete({
            where: { id },
            include: {
                menuOption: {
                    include: {
                        option: true
                    }
                }
            },
        });
    }
    async uploadMenuImage(file, data) {
        const publicurl = await UploadFunction.uploadimage("menuimg", data.menuId, file);
        await prisma_1.default.menu.update({
            where: { id: data.menuId },
            data: {
                image: publicurl.data.publicUrl
            }
        });
        return publicurl.data.publicUrl;
    }
};
exports.MenuService = MenuService;
exports.MenuService = MenuService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], MenuService);
//# sourceMappingURL=menu.service.js.map