import { CreateUpdateMerchantDto, GetMerchantDTO, MerchantImgUploadDto, NearbyShopDTO, ReviewMerchantDTO, UpdateOpeningHours, MerchantUpdateAddressDto } from './merchant.dto';
import { MerchantService } from './merchant.service';
export declare class MerchantController {
    private readonly merchantService;
    constructor(merchantService: MerchantService);
    findAll(): Promise<{
        data: {
            openingHours: any;
            user: {
                id: string;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
            address: {
                id: string;
                address: string;
                city: string;
                state: string;
                country: string;
                postalCode: string;
                latitude: number | null;
                longitude: number | null;
                createdAt: Date;
                updatedAt: Date;
            };
            menu: {
                id: string;
                name: string;
                image: string | null;
                basePrice: number;
                description: string;
                createdAt: Date;
                updatedAt: Date | null;
                active: boolean;
                category: string;
                merchantId: string;
            }[];
            rating: ({
                user: {
                    id: string;
                    email: string;
                    name: string;
                    roleId: string;
                    phoneNumber: string;
                    dateOfBirth: Date;
                    addressId: string | null;
                    profilePic: string | null;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date;
                    membershipTierId: string | null;
                    creditId: string | null;
                    loyaltyPointId: string | null;
                };
            } & {
                id: string;
                rating: number;
                review: string;
                createdAt: Date;
                updatedAt: Date | null;
                merchantId: string;
                reviewerId: string;
                orderId: string | null;
            })[];
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        }[];
        message: string;
    }>;
    findAllActiveMerchant(): Promise<{
        data: {
            openingHours: any;
            user: {
                id: string;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
            address: {
                id: string;
                address: string;
                city: string;
                state: string;
                country: string;
                postalCode: string;
                latitude: number | null;
                longitude: number | null;
                createdAt: Date;
                updatedAt: Date;
            };
            menu: {
                id: string;
                name: string;
                image: string | null;
                basePrice: number;
                description: string;
                createdAt: Date;
                updatedAt: Date | null;
                active: boolean;
                category: string;
                merchantId: string;
            }[];
            rating: ({
                user: {
                    id: string;
                    email: string;
                    name: string;
                    roleId: string;
                    phoneNumber: string;
                    dateOfBirth: Date;
                    addressId: string | null;
                    profilePic: string | null;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date;
                    membershipTierId: string | null;
                    creditId: string | null;
                    loyaltyPointId: string | null;
                };
            } & {
                id: string;
                rating: number;
                review: string;
                createdAt: Date;
                updatedAt: Date | null;
                merchantId: string;
                reviewerId: string;
                orderId: string | null;
            })[];
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        }[];
        message: string;
    }>;
    findOne(reqData: GetMerchantDTO): Promise<{
        data: {
            user: {
                id: string;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
            address: {
                id: string;
                address: string;
                city: string;
                state: string;
                country: string;
                postalCode: string;
                latitude: number | null;
                longitude: number | null;
                createdAt: Date;
                updatedAt: Date;
            };
            menu: {
                id: string;
                name: string;
                image: string | null;
                basePrice: number;
                description: string;
                createdAt: Date;
                updatedAt: Date | null;
                active: boolean;
                category: string;
                merchantId: string;
            }[];
            rating: ({
                user: {
                    id: string;
                    email: string;
                    name: string;
                    roleId: string;
                    phoneNumber: string;
                    dateOfBirth: Date;
                    addressId: string | null;
                    profilePic: string | null;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date;
                    membershipTierId: string | null;
                    creditId: string | null;
                    loyaltyPointId: string | null;
                };
            } & {
                id: string;
                rating: number;
                review: string;
                createdAt: Date;
                updatedAt: Date | null;
                merchantId: string;
                reviewerId: string;
                orderId: string | null;
            })[];
        } & {
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            openingHours: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        };
        message: string;
    }>;
    create(reqData: CreateUpdateMerchantDto): Promise<{
        data: {
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            openingHours: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        };
        message: string;
    }>;
    uploadMenuImg(imagefile: Express.Multer.File, reqData: MerchantImgUploadDto): Promise<{
        data: string;
        message: string;
    }>;
    nearbyshop(reqData: NearbyShopDTO): Promise<{
        data: any[] | {
            error: string;
        };
        message: string;
    }>;
    updateReview(id: string, reqData: ReviewMerchantDTO): Promise<{
        data: {
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            openingHours: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        };
        message: string;
    }>;
    updateOpeningHours(id: string, reqData: UpdateOpeningHours): Promise<{
        data: {
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            openingHours: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        };
        message: string;
    }>;
    updateAddress(id: string, reqData: MerchantUpdateAddressDto): Promise<{
        data: {
            id: string;
            address: string;
            city: string;
            state: string;
            country: string;
            postalCode: string;
            latitude: number | null;
            longitude: number | null;
            createdAt: Date;
            updatedAt: Date;
        };
        message: string;
    }>;
    update(id: string, reqData: CreateUpdateMerchantDto): Promise<{
        data: {
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            openingHours: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        };
        message: string;
    }>;
    remove(id: string): Promise<{
        data: {
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            openingHours: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        };
        message: string;
    }>;
}
