"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MerchantController = void 0;
const utils_1 = require("../utils");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const platform_express_1 = require("@nestjs/platform-express");
const merchant_dto_1 = require("./merchant.dto");
const merchant_service_1 = require("./merchant.service");
let MerchantController = class MerchantController {
    constructor(merchantService) {
        this.merchantService = merchantService;
    }
    async findAll() {
        let data = await this.merchantService.findAll();
        data.forEach((elem, index) => {
            data[index]['overallRating'] = (0, utils_1.calculateMerchantRating)(elem.rating);
        });
        return { data: data, message: 'Merchant Retrieved All' };
    }
    async findAllActiveMerchant() {
        let data = await this.merchantService.findAllActiveMerchant();
        data.forEach((elem, index) => {
            data[index]['overallRating'] = (0, utils_1.calculateMerchantRating)(elem.rating);
        });
        return { data: data, message: 'Merchant Retrieved All' };
    }
    async findOne(reqData) {
        const { id, latitude, longitude } = reqData;
        const userLatitude = parseFloat(latitude.toString());
        const userLongitude = parseFloat(longitude.toString());
        let data = await this.merchantService.findOne(id);
        data['overallRating'] = (0, utils_1.calculateMerchantRating)(data.rating);
        data['distance'] = (0, utils_1.calculateDistanceBetweenMerchantandUser)(userLatitude, userLongitude, data.address.latitude, data.address.longitude);
        return { data: data, message: 'Merchant Retrieved One' };
    }
    async create(reqData) {
        const data = await this.merchantService.create(reqData);
        return { data: data, message: 'Merchant Created' };
    }
    async uploadMenuImg(imagefile, reqData) {
        const data = await this.merchantService.uploadMenuImage(imagefile, reqData);
        return { data: data, message: 'Merchant Image Upload Successful' };
    }
    async nearbyshop(reqData) {
        const { latitude, longitude } = reqData;
        common_1.Logger.log(latitude, "nearbyshop");
        common_1.Logger.log(longitude, "nearbyshop");
        const data = await this.merchantService.findNearbyShop(latitude, longitude);
        return { data: data, message: 'Nearby Shop Data' };
    }
    async updateReview(id, reqData) {
        const data = await this.merchantService.updateReview(id, reqData);
        return { data: data, message: 'Merchant Review Updated' };
    }
    async updateOpeningHours(id, reqData) {
        const data = await this.merchantService.updateOpeningHours(id, reqData);
        return { data: data, message: 'Merchant Updated' };
    }
    async updateAddress(id, reqData) {
        const data = await this.merchantService.updateAddress(id, reqData);
        return { data: data, message: 'Merchant Updated' };
    }
    async update(id, reqData) {
        const data = await this.merchantService.update(id, reqData);
        return { data: data, message: 'Merchant Updated' };
    }
    async remove(id) {
        const data = await this.merchantService.remove(id);
        return { data: data, message: 'Merchant Deleted' };
    }
};
exports.MerchantController = MerchantController;
__decorate([
    (0, common_1.Get)('getallmerchant'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('getallactivemerchant'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "findAllActiveMerchant", null);
__decorate([
    (0, common_1.Post)('getmerchant'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [merchant_dto_1.GetMerchantDTO]),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "findOne", null);
__decorate([
    (0, common_1.Post)('createmerchant'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [merchant_dto_1.CreateUpdateMerchantDto]),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('upload'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('imagefile')),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, merchant_dto_1.MerchantImgUploadDto]),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "uploadMenuImg", null);
__decorate([
    (0, common_1.Post)('nearbyshop'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [merchant_dto_1.NearbyShopDTO]),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "nearbyshop", null);
__decorate([
    (0, common_1.Put)(':id/review'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, merchant_dto_1.ReviewMerchantDTO]),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "updateReview", null);
__decorate([
    (0, common_1.Put)(':id/openinghours'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, merchant_dto_1.UpdateOpeningHours]),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "updateOpeningHours", null);
__decorate([
    (0, common_1.Put)(':id/address'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, merchant_dto_1.MerchantUpdateAddressDto]),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "updateAddress", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, merchant_dto_1.CreateUpdateMerchantDto]),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], MerchantController.prototype, "remove", null);
exports.MerchantController = MerchantController = __decorate([
    (0, swagger_1.ApiTags)('Merchants'),
    (0, common_1.Controller)('merchants'),
    __metadata("design:paramtypes", [merchant_service_1.MerchantService])
], MerchantController);
//# sourceMappingURL=merchant.controller.js.map