import { CreateUpdateMerchantDto, ReviewMerchantDTO, MerchantImgUploadDto, UpdateOpeningHours, MerchantUpdateAddressDto } from './merchant.dto';
export declare class MerchantService {
    constructor();
    findAll(): Promise<{
        openingHours: any;
        user: {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        };
        address: {
            id: string;
            address: string;
            city: string;
            state: string;
            country: string;
            postalCode: string;
            latitude: number | null;
            longitude: number | null;
            createdAt: Date;
            updatedAt: Date;
        };
        menu: {
            id: string;
            name: string;
            image: string | null;
            basePrice: number;
            description: string;
            createdAt: Date;
            updatedAt: Date | null;
            active: boolean;
            category: string;
            merchantId: string;
        }[];
        rating: ({
            user: {
                id: string;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
        } & {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        })[];
        id: string;
        name: string;
        image: string | null;
        businessType: string;
        businessRegistrationNumber: string | null;
        contractSigneeName: string | null;
        contractSigneeNRIC: string | null;
        userId: string;
        addressId: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date | null;
        storyDescription: string | null;
    }[]>;
    findAllActiveMerchant(): Promise<{
        openingHours: any;
        user: {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        };
        address: {
            id: string;
            address: string;
            city: string;
            state: string;
            country: string;
            postalCode: string;
            latitude: number | null;
            longitude: number | null;
            createdAt: Date;
            updatedAt: Date;
        };
        menu: {
            id: string;
            name: string;
            image: string | null;
            basePrice: number;
            description: string;
            createdAt: Date;
            updatedAt: Date | null;
            active: boolean;
            category: string;
            merchantId: string;
        }[];
        rating: ({
            user: {
                id: string;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
        } & {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        })[];
        id: string;
        name: string;
        image: string | null;
        businessType: string;
        businessRegistrationNumber: string | null;
        contractSigneeName: string | null;
        contractSigneeNRIC: string | null;
        userId: string;
        addressId: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date | null;
        storyDescription: string | null;
    }[]>;
    findOne(id: string): Promise<{
        user: {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        };
        address: {
            id: string;
            address: string;
            city: string;
            state: string;
            country: string;
            postalCode: string;
            latitude: number | null;
            longitude: number | null;
            createdAt: Date;
            updatedAt: Date;
        };
        menu: {
            id: string;
            name: string;
            image: string | null;
            basePrice: number;
            description: string;
            createdAt: Date;
            updatedAt: Date | null;
            active: boolean;
            category: string;
            merchantId: string;
        }[];
        rating: ({
            user: {
                id: string;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
        } & {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        })[];
    } & {
        id: string;
        name: string;
        image: string | null;
        businessType: string;
        businessRegistrationNumber: string | null;
        contractSigneeName: string | null;
        contractSigneeNRIC: string | null;
        openingHours: string | null;
        userId: string;
        addressId: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date | null;
        storyDescription: string | null;
    }>;
    create(data: CreateUpdateMerchantDto): Promise<{
        id: string;
        name: string;
        image: string | null;
        businessType: string;
        businessRegistrationNumber: string | null;
        contractSigneeName: string | null;
        contractSigneeNRIC: string | null;
        openingHours: string | null;
        userId: string;
        addressId: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date | null;
        storyDescription: string | null;
    }>;
    update(id: string, data: CreateUpdateMerchantDto): Promise<{
        id: string;
        name: string;
        image: string | null;
        businessType: string;
        businessRegistrationNumber: string | null;
        contractSigneeName: string | null;
        contractSigneeNRIC: string | null;
        openingHours: string | null;
        userId: string;
        addressId: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date | null;
        storyDescription: string | null;
    }>;
    updateOpeningHours(id: string, data: UpdateOpeningHours): Promise<{
        id: string;
        name: string;
        image: string | null;
        businessType: string;
        businessRegistrationNumber: string | null;
        contractSigneeName: string | null;
        contractSigneeNRIC: string | null;
        openingHours: string | null;
        userId: string;
        addressId: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date | null;
        storyDescription: string | null;
    }>;
    updateAddress(id: string, data: MerchantUpdateAddressDto): Promise<{
        id: string;
        address: string;
        city: string;
        state: string;
        country: string;
        postalCode: string;
        latitude: number | null;
        longitude: number | null;
        createdAt: Date;
        updatedAt: Date;
    }>;
    updateReview(id: string, data: ReviewMerchantDTO): Promise<{
        id: string;
        name: string;
        image: string | null;
        businessType: string;
        businessRegistrationNumber: string | null;
        contractSigneeName: string | null;
        contractSigneeNRIC: string | null;
        openingHours: string | null;
        userId: string;
        addressId: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date | null;
        storyDescription: string | null;
    }>;
    remove(id: string): Promise<{
        id: string;
        name: string;
        image: string | null;
        businessType: string;
        businessRegistrationNumber: string | null;
        contractSigneeName: string | null;
        contractSigneeNRIC: string | null;
        openingHours: string | null;
        userId: string;
        addressId: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date | null;
        storyDescription: string | null;
    }>;
    findNearbyShop(latitude: number, longitude: number): Promise<any[] | {
        error: string;
    }>;
    filterNearbyShops(userLatitude: any, userLongitude: any, shops: any): Promise<any[]>;
    calculateDistance(lat1: any, lon1: any, lat2: any, lon2: any): Promise<number>;
    uploadMenuImage(file: Express.Multer.File, data: MerchantImgUploadDto): Promise<string>;
}
