"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MerchantService = void 0;
const common_1 = require("@nestjs/common");
const prisma_1 = require("../prisma");
const utils_1 = require("../utils");
let MerchantService = class MerchantService {
    constructor() { }
    async findAll() {
        const allmerchant = await prisma_1.default.merchant.findMany({
            include: {
                address: true,
                menu: true,
                rating: {
                    include: {
                        user: true
                    }
                },
                user: true
            }
        });
        const restructuredOrders = allmerchant.map((merchant) => ({
            ...merchant,
            openingHours: JSON.parse(merchant.openingHours)
        }));
        return restructuredOrders;
    }
    async findAllActiveMerchant() {
        const allactive = await prisma_1.default.merchant.findMany({
            where: { active: true },
            include: {
                address: true,
                menu: true,
                rating: {
                    include: {
                        user: true
                    }
                },
                user: true
            }
        });
        const restructuredOrders = allactive.map((merchant) => ({
            ...merchant,
            openingHours: JSON.parse(merchant.openingHours)
        }));
        return restructuredOrders;
    }
    async findOne(id) {
        return prisma_1.default.merchant.findUnique({
            where: { id },
            include: {
                address: true,
                menu: true,
                rating: {
                    include: {
                        user: true
                    }
                },
                user: true
            }
        });
    }
    async create(data) {
        const openinghours = data.openingHours ? data.openingHours : JSON.stringify({
            "sunday": { "open": "", "close": "", "rest": true },
            "monday": { "open": "", "close": "", "rest": true },
            "tuesday": { "open": "", "close": "", "rest": true },
            "wednesday": { "open": "", "close": "", "rest": true },
            "thursday": { "open": "", "close": "", "rest": true },
            "friday": { "open": "", "close": "", "rest": true },
            "saturday": { "open": "", "close": "", "rest": true }
        });
        const user = await prisma_1.default.user.findUnique({
            where: {
                email: data.email
            }
        });
        if ((0, utils_1.isEmpty)(user)) {
            throw new common_1.BadRequestException({
                error: 'User email is not MaCoffee user yet. Please register as MaCoffee user first to proceed.',
                message: ['User email is not MaCoffee user yet. Please register as MaCoffee user first to proceed.'],
                statusCode: 400
            });
        }
        return prisma_1.default.merchant.create({
            data: {
                name: data.name,
                user: {
                    connect: {
                        id: user.id
                    }
                },
                storyDescription: data.name,
                openingHours: openinghours,
                businessType: data.businessType,
                ...(data.image && {
                    image: data.image
                }),
                ...(data.businessRegistrationNumber && {
                    businessRegistrationNumber: data.businessRegistrationNumber
                }),
                ...(data.contractSigneeName && {
                    contractSigneeName: data.contractSigneeName
                }),
                ...(data.contractSigneeNRIC && {
                    contractSigneeNRIC: data.contractSigneeNRIC
                }),
                address: {
                    create: {
                        address: data.address,
                        city: data.city,
                        state: data.state,
                        country: data.country,
                        postalCode: data.postalCode
                    }
                }
            },
        });
    }
    async update(id, data) {
        const merchant = await prisma_1.default.merchant.findUnique({
            where: { id },
            include: {
                address: true
            }
        });
        return prisma_1.default.merchant.update({
            where: { id },
            data: {
                name: data.name,
                storyDescription: data.storyDescription,
                businessType: data.businessType,
                ...(data.image && {
                    image: data.image
                }),
                ...(data.businessRegistrationNumber && {
                    businessRegistrationNumber: data.businessRegistrationNumber
                }),
                ...(data.contractSigneeName && {
                    contractSigneeName: data.contractSigneeName
                }),
                ...(data.contractSigneeNRIC && {
                    contractSigneeNRIC: data.contractSigneeNRIC
                }),
                address: {
                    update: {
                        where: { id: merchant.addressId },
                        data: {
                            address: data.address,
                            city: data.city,
                            state: data.state,
                            country: data.country,
                            postalCode: data.postalCode,
                            latitude: data.latitude,
                            longitude: data.longitude
                        },
                    },
                },
            }
        });
    }
    async updateOpeningHours(id, data) {
        return prisma_1.default.merchant.update({
            where: { id },
            data: {
                openingHours: JSON.stringify(data.openingHours)
            }
        });
    }
    async updateAddress(id, data) {
        return prisma_1.default.address.update({
            where: { id },
            data: {
                ...data,
                updatedAt: new Date(),
            }
        });
    }
    async updateReview(id, data) {
        return prisma_1.default.merchant.update({
            where: { id },
            data: {
                rating: {
                    create: {
                        reviewerId: data.reviewerId,
                        orderId: data.orderId,
                        rating: data.rating,
                        review: data.review
                    }
                }
            }
        });
    }
    async remove(id) {
        return prisma_1.default.merchant.delete({
            where: { id },
        });
    }
    async findNearbyShop(latitude, longitude) {
        var shops = await prisma_1.default.merchant.findMany({
            where: { active: true },
            include: {
                address: true
            }
        });
        if (!latitude || !longitude) {
            return { error: 'Latitude and longitude are required.' };
        }
        const userLatitude = parseFloat(latitude.toString());
        const userLongitude = parseFloat(longitude.toString());
        if (isNaN(userLatitude) || isNaN(userLongitude)) {
            return { error: 'Invalid latitude or longitude.' };
        }
        const nearbyShops = await this.filterNearbyShops(userLatitude, userLongitude, shops);
        return nearbyShops;
    }
    async filterNearbyShops(userLatitude, userLongitude, shops) {
        const nearbyShops = [];
        shops.forEach(async (shop) => {
            const distance = await this.calculateDistance(userLatitude, userLongitude, shop.address.latitude, shop.address.longitude);
            if (distance <= 10) {
                nearbyShops.push({ ...shop, distance });
            }
        });
        return nearbyShops;
    }
    async calculateDistance(lat1, lon1, lat2, lon2) {
        const R = 6371;
        const dLat = (lat2 - lat1) * (Math.PI / 180);
        const dLon = (lon2 - lon1) * (Math.PI / 180);
        const a = Math.sin(dLat / 2) * Math.sin(dLat / 2) +
            Math.cos((lat1) * (Math.PI / 180)) * Math.cos((lat2) * (Math.PI / 180)) *
                Math.sin(dLon / 2) * Math.sin(dLon / 2);
        const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
        const distance = R * c;
        return distance;
    }
    async uploadMenuImage(file, data) {
        const UploadFunction = new utils_1.UploadImg();
        const publicurl = await UploadFunction.uploadimage("merchantprofilepic", data.merchantId, file);
        await prisma_1.default.merchant.update({
            where: { id: data.merchantId },
            data: {
                image: publicurl.data.publicUrl
            }
        });
        return publicurl.data.publicUrl;
    }
};
exports.MerchantService = MerchantService;
exports.MerchantService = MerchantService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], MerchantService);
//# sourceMappingURL=merchant.service.js.map