import { CreateUpdateOrderDto, UpdateOrderStatusdto, userOrderHistoryDto, merchantOrderHistoryDto } from './order.dto';
import { OrderService } from './order.service';
export declare class OrderController {
    private orderService;
    constructor(orderService: OrderService);
    create(reqData: CreateUpdateOrderDto): Promise<{
        data: {
            orderDetails: ({
                orderDetailOptions: {
                    id: string;
                    type: string;
                    name: string;
                    price: number;
                    createdAt: Date;
                    updatedAt: Date | null;
                    orderDetailsId: string;
                }[];
            } & {
                id: string;
                quantity: number;
                basePrice: number;
                createdAt: Date;
                updatedAt: Date | null;
                orderId: string;
                menuId: string;
            })[];
        } & {
            id: string;
            referenceId: string | null;
            totalAmount: number;
            orderTime: Date;
            pickupTime: Date;
            status: string;
            createdAt: Date;
            updatedAt: Date | null;
            completedAt: Date | null;
            transactionId: string | null;
            merchantId: string | null;
            userId: string;
            userVehicleId: string | null;
            voucherUsed: boolean;
        };
        message: string;
    }>;
    findByUserId(reqData: userOrderHistoryDto): Promise<{
        data: {
            id: string;
            totalAmount: number;
            orderTime: Date;
            pickupTime: Date;
            status: string;
            createdAt: Date;
            updatedAt: Date;
            transactionId: string;
            merchantId: string;
            merchantAddress: {
                id: string;
                address: string;
                city: string;
                state: string;
                country: string;
                postalCode: string;
                latitude: number | null;
                longitude: number | null;
                createdAt: Date;
                updatedAt: Date;
            };
            merchantName: string;
            orderDetails: {
                id: string;
                quantity: number;
                basePrice: number;
                createdAt: Date;
                updatedAt: Date;
                orderId: string;
                menuId: string;
                menuName: string;
                menuImage: string;
                orderDetailOptions: {
                    id: string;
                    type: string;
                    name: string;
                    price: number;
                    createdAt: Date;
                    updatedAt: Date | null;
                    orderDetailsId: string;
                }[];
            }[];
            transaction: {
                id: string;
                totalAmount: number;
                paymentTime: Date;
                paymentMethod: string;
                createdAt: Date;
                updatedAt: Date | null;
                orderId: string;
            };
            rating: {
                id: string;
                rating: number;
                review: string;
                createdAt: Date;
                updatedAt: Date | null;
                merchantId: string;
                reviewerId: string;
                orderId: string | null;
            }[];
            vehicle: {
                id: string;
                plate: string;
                userId: string;
                createdAt: Date;
                updatedAt: Date | null;
            };
            user: {
                id: string;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
        }[];
        message: string;
    }>;
    findByMerchantId(reqData: merchantOrderHistoryDto): Promise<{
        data: {
            orders: {
                id: string;
                totalAmount: number;
                orderTime: Date;
                pickupTime: Date;
                status: string;
                createdAt: Date;
                updatedAt: Date;
                transactionId: string;
                merchantId: string;
                merchantAddress: {
                    id: string;
                    address: string;
                    city: string;
                    state: string;
                    country: string;
                    postalCode: string;
                    latitude: number | null;
                    longitude: number | null;
                    createdAt: Date;
                    updatedAt: Date;
                };
                merchantName: string;
                orderDetails: {
                    id: string;
                    quantity: number;
                    basePrice: number;
                    createdAt: Date;
                    updatedAt: Date;
                    orderId: string;
                    menuId: string;
                    menuName: string;
                    menuImage: string;
                    orderDetailOptions: {
                        id: string;
                        type: string;
                        name: string;
                        price: number;
                        createdAt: Date;
                        updatedAt: Date | null;
                        orderDetailsId: string;
                    }[];
                }[];
                transaction: {
                    id: string;
                    totalAmount: number;
                    paymentTime: Date;
                    paymentMethod: string;
                    createdAt: Date;
                    updatedAt: Date | null;
                    orderId: string;
                };
                rating: {
                    id: string;
                    rating: number;
                    review: string;
                    createdAt: Date;
                    updatedAt: Date | null;
                    merchantId: string;
                    reviewerId: string;
                    orderId: string | null;
                }[];
                vehicle: {
                    id: string;
                    plate: string;
                    userId: string;
                    createdAt: Date;
                    updatedAt: Date | null;
                };
                user: {
                    id: string;
                    email: string;
                    name: string;
                    roleId: string;
                    phoneNumber: string;
                    dateOfBirth: Date;
                    addressId: string | null;
                    profilePic: string | null;
                    active: boolean;
                    createdAt: Date;
                    updatedAt: Date;
                    membershipTierId: string | null;
                    creditId: string | null;
                    loyaltyPointId: string | null;
                };
            }[];
            totalCount: number;
        };
        message: string;
    }>;
    findAll(): Promise<{
        data: ({
            user: {
                id: string;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
            userVehicle: {
                id: string;
                plate: string;
                userId: string;
                createdAt: Date;
                updatedAt: Date | null;
            };
            orderDetails: ({
                orderDetailOptions: {
                    id: string;
                    type: string;
                    name: string;
                    price: number;
                    createdAt: Date;
                    updatedAt: Date | null;
                    orderDetailsId: string;
                }[];
            } & {
                id: string;
                quantity: number;
                basePrice: number;
                createdAt: Date;
                updatedAt: Date | null;
                orderId: string;
                menuId: string;
            })[];
            transaction: {
                id: string;
                totalAmount: number;
                paymentTime: Date;
                paymentMethod: string;
                createdAt: Date;
                updatedAt: Date | null;
                orderId: string;
            };
            rating: {
                id: string;
                rating: number;
                review: string;
                createdAt: Date;
                updatedAt: Date | null;
                merchantId: string;
                reviewerId: string;
                orderId: string | null;
            }[];
        } & {
            id: string;
            referenceId: string | null;
            totalAmount: number;
            orderTime: Date;
            pickupTime: Date;
            status: string;
            createdAt: Date;
            updatedAt: Date | null;
            completedAt: Date | null;
            transactionId: string | null;
            merchantId: string | null;
            userId: string;
            userVehicleId: string | null;
            voucherUsed: boolean;
        })[];
        message: string;
    }>;
    findOne(id: string): Promise<{
        data: {
            id: string;
            voucherUsed: boolean;
            totalAmount: number;
            orderTime: Date;
            pickupTime: Date;
            status: string;
            createdAt: Date;
            updatedAt: Date;
            transactionId: string;
            merchantId: string;
            merchantAddress: {
                id: string;
                address: string;
                city: string;
                state: string;
                country: string;
                postalCode: string;
                latitude: number | null;
                longitude: number | null;
                createdAt: Date;
                updatedAt: Date;
            };
            merchantName: string;
            orderDetails: {
                id: string;
                quantity: number;
                basePrice: number;
                createdAt: Date;
                updatedAt: Date;
                orderId: string;
                menuId: string;
                menuName: string;
                menuImage: string;
                orderDetailOptions: {
                    id: string;
                    type: string;
                    name: string;
                    price: number;
                    createdAt: Date;
                    updatedAt: Date | null;
                    orderDetailsId: string;
                }[];
            }[];
            transaction: {
                id: string;
                totalAmount: number;
                paymentTime: Date;
                paymentMethod: string;
                createdAt: Date;
                updatedAt: Date | null;
                orderId: string;
            };
            rating: {
                id: string;
                rating: number;
                review: string;
                createdAt: Date;
                updatedAt: Date | null;
                merchantId: string;
                reviewerId: string;
                orderId: string | null;
            }[];
            vehicle: {
                id: string;
                plate: string;
                userId: string;
                createdAt: Date;
                updatedAt: Date | null;
            };
            user: {
                id: string;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
        };
        message: string;
    }>;
    update(id: string, reqData: CreateUpdateOrderDto): Promise<{
        data: {
            id: string;
            referenceId: string | null;
            totalAmount: number;
            orderTime: Date;
            pickupTime: Date;
            status: string;
            createdAt: Date;
            updatedAt: Date | null;
            completedAt: Date | null;
            transactionId: string | null;
            merchantId: string | null;
            userId: string;
            userVehicleId: string | null;
            voucherUsed: boolean;
        };
        message: string;
    }>;
    updateStatus(id: string, reqData: UpdateOrderStatusdto): Promise<{
        data: {
            id: string;
            referenceId: string | null;
            totalAmount: number;
            orderTime: Date;
            pickupTime: Date;
            status: string;
            createdAt: Date;
            updatedAt: Date | null;
            completedAt: Date | null;
            transactionId: string | null;
            merchantId: string | null;
            userId: string;
            userVehicleId: string | null;
            voucherUsed: boolean;
        };
        message: string;
    }>;
    remove(id: string): Promise<{
        data: {
            orderDetails: ({
                orderDetailOptions: {
                    id: string;
                    type: string;
                    name: string;
                    price: number;
                    createdAt: Date;
                    updatedAt: Date | null;
                    orderDetailsId: string;
                }[];
            } & {
                id: string;
                quantity: number;
                basePrice: number;
                createdAt: Date;
                updatedAt: Date | null;
                orderId: string;
                menuId: string;
            })[];
            transaction: {
                id: string;
                totalAmount: number;
                paymentTime: Date;
                paymentMethod: string;
                createdAt: Date;
                updatedAt: Date | null;
                orderId: string;
            };
        } & {
            id: string;
            referenceId: string | null;
            totalAmount: number;
            orderTime: Date;
            pickupTime: Date;
            status: string;
            createdAt: Date;
            updatedAt: Date | null;
            completedAt: Date | null;
            transactionId: string | null;
            merchantId: string | null;
            userId: string;
            userVehicleId: string | null;
            voucherUsed: boolean;
        };
        message: string;
    }>;
}
