import { CreateUpdateOrderDto, UpdateOrderStatusdto, userOrderHistoryDto, merchantOrderHistoryDto } from './order.dto';
import { MembershipService } from 'src/membership/membership.service';
export declare class OrderService {
    private readonly membershipService;
    constructor(membershipService: MembershipService);
    create(data: CreateUpdateOrderDto): Promise<{
        orderDetails: ({
            orderDetailOptions: {
                id: string;
                type: string;
                name: string;
                price: number;
                createdAt: Date;
                updatedAt: Date | null;
                orderDetailsId: string;
            }[];
        } & {
            id: string;
            quantity: number;
            basePrice: number;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
            menuId: string;
        })[];
    } & {
        id: string;
        referenceId: string | null;
        totalAmount: number;
        orderTime: Date;
        pickupTime: Date;
        status: string;
        createdAt: Date;
        updatedAt: Date | null;
        completedAt: Date | null;
        transactionId: string | null;
        merchantId: string | null;
        userId: string;
        userVehicleId: string | null;
        voucherUsed: boolean;
    }>;
    findAll(): Promise<({
        user: {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        };
        userVehicle: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        orderDetails: ({
            orderDetailOptions: {
                id: string;
                type: string;
                name: string;
                price: number;
                createdAt: Date;
                updatedAt: Date | null;
                orderDetailsId: string;
            }[];
        } & {
            id: string;
            quantity: number;
            basePrice: number;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
            menuId: string;
        })[];
        transaction: {
            id: string;
            totalAmount: number;
            paymentTime: Date;
            paymentMethod: string;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
        };
        rating: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        }[];
    } & {
        id: string;
        referenceId: string | null;
        totalAmount: number;
        orderTime: Date;
        pickupTime: Date;
        status: string;
        createdAt: Date;
        updatedAt: Date | null;
        completedAt: Date | null;
        transactionId: string | null;
        merchantId: string | null;
        userId: string;
        userVehicleId: string | null;
        voucherUsed: boolean;
    })[]>;
    findOne(id: string): Promise<{
        id: string;
        voucherUsed: boolean;
        totalAmount: number;
        orderTime: Date;
        pickupTime: Date;
        status: string;
        createdAt: Date;
        updatedAt: Date;
        transactionId: string;
        merchantId: string;
        merchantAddress: {
            id: string;
            address: string;
            city: string;
            state: string;
            country: string;
            postalCode: string;
            latitude: number | null;
            longitude: number | null;
            createdAt: Date;
            updatedAt: Date;
        };
        merchantName: string;
        orderDetails: {
            id: string;
            quantity: number;
            basePrice: number;
            createdAt: Date;
            updatedAt: Date;
            orderId: string;
            menuId: string;
            menuName: string;
            menuImage: string;
            orderDetailOptions: {
                id: string;
                type: string;
                name: string;
                price: number;
                createdAt: Date;
                updatedAt: Date | null;
                orderDetailsId: string;
            }[];
        }[];
        transaction: {
            id: string;
            totalAmount: number;
            paymentTime: Date;
            paymentMethod: string;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
        };
        rating: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        }[];
        vehicle: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        user: {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        };
    }>;
    findByUserId(data: userOrderHistoryDto): Promise<{
        id: string;
        totalAmount: number;
        orderTime: Date;
        pickupTime: Date;
        status: string;
        createdAt: Date;
        updatedAt: Date;
        transactionId: string;
        merchantId: string;
        merchantAddress: {
            id: string;
            address: string;
            city: string;
            state: string;
            country: string;
            postalCode: string;
            latitude: number | null;
            longitude: number | null;
            createdAt: Date;
            updatedAt: Date;
        };
        merchantName: string;
        orderDetails: {
            id: string;
            quantity: number;
            basePrice: number;
            createdAt: Date;
            updatedAt: Date;
            orderId: string;
            menuId: string;
            menuName: string;
            menuImage: string;
            orderDetailOptions: {
                id: string;
                type: string;
                name: string;
                price: number;
                createdAt: Date;
                updatedAt: Date | null;
                orderDetailsId: string;
            }[];
        }[];
        transaction: {
            id: string;
            totalAmount: number;
            paymentTime: Date;
            paymentMethod: string;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
        };
        rating: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        }[];
        vehicle: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        user: {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        };
    }[]>;
    findByMerchantId(data: merchantOrderHistoryDto): Promise<{
        orders: {
            id: string;
            totalAmount: number;
            orderTime: Date;
            pickupTime: Date;
            status: string;
            createdAt: Date;
            updatedAt: Date;
            transactionId: string;
            merchantId: string;
            merchantAddress: {
                id: string;
                address: string;
                city: string;
                state: string;
                country: string;
                postalCode: string;
                latitude: number | null;
                longitude: number | null;
                createdAt: Date;
                updatedAt: Date;
            };
            merchantName: string;
            orderDetails: {
                id: string;
                quantity: number;
                basePrice: number;
                createdAt: Date;
                updatedAt: Date;
                orderId: string;
                menuId: string;
                menuName: string;
                menuImage: string;
                orderDetailOptions: {
                    id: string;
                    type: string;
                    name: string;
                    price: number;
                    createdAt: Date;
                    updatedAt: Date | null;
                    orderDetailsId: string;
                }[];
            }[];
            transaction: {
                id: string;
                totalAmount: number;
                paymentTime: Date;
                paymentMethod: string;
                createdAt: Date;
                updatedAt: Date | null;
                orderId: string;
            };
            rating: {
                id: string;
                rating: number;
                review: string;
                createdAt: Date;
                updatedAt: Date | null;
                merchantId: string;
                reviewerId: string;
                orderId: string | null;
            }[];
            vehicle: {
                id: string;
                plate: string;
                userId: string;
                createdAt: Date;
                updatedAt: Date | null;
            };
            user: {
                id: string;
                email: string;
                name: string;
                roleId: string;
                phoneNumber: string;
                dateOfBirth: Date;
                addressId: string | null;
                profilePic: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date;
                membershipTierId: string | null;
                creditId: string | null;
                loyaltyPointId: string | null;
            };
        }[];
        totalCount: number;
    }>;
    update(id: string, data: CreateUpdateOrderDto): Promise<{
        id: string;
        referenceId: string | null;
        totalAmount: number;
        orderTime: Date;
        pickupTime: Date;
        status: string;
        createdAt: Date;
        updatedAt: Date | null;
        completedAt: Date | null;
        transactionId: string | null;
        merchantId: string | null;
        userId: string;
        userVehicleId: string | null;
        voucherUsed: boolean;
    }>;
    private updateMembershipTier;
    updateStatus(id: string, data: UpdateOrderStatusdto): Promise<{
        id: string;
        referenceId: string | null;
        totalAmount: number;
        orderTime: Date;
        pickupTime: Date;
        status: string;
        createdAt: Date;
        updatedAt: Date | null;
        completedAt: Date | null;
        transactionId: string | null;
        merchantId: string | null;
        userId: string;
        userVehicleId: string | null;
        voucherUsed: boolean;
    }>;
    remove(id: string): Promise<{
        orderDetails: ({
            orderDetailOptions: {
                id: string;
                type: string;
                name: string;
                price: number;
                createdAt: Date;
                updatedAt: Date | null;
                orderDetailsId: string;
            }[];
        } & {
            id: string;
            quantity: number;
            basePrice: number;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
            menuId: string;
        })[];
        transaction: {
            id: string;
            totalAmount: number;
            paymentTime: Date;
            paymentMethod: string;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
        };
    } & {
        id: string;
        referenceId: string | null;
        totalAmount: number;
        orderTime: Date;
        pickupTime: Date;
        status: string;
        createdAt: Date;
        updatedAt: Date | null;
        completedAt: Date | null;
        transactionId: string | null;
        merchantId: string | null;
        userId: string;
        userVehicleId: string | null;
        voucherUsed: boolean;
    }>;
}
