"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const credit_service_1 = require("../credit/credit.service");
const payment_dto_1 = require("./payment.dto");
const payment_service_1 = require("./payment.service");
let PaymentController = class PaymentController {
    constructor(paymentService, creditService) {
        this.paymentService = paymentService;
        this.creditService = creditService;
    }
    async reload(reloadDto) {
        const paymentData = await this.paymentService.createBillplzPaymentRequest(reloadDto.userId, reloadDto.amount);
        return { data: paymentData, message: 'Reload Amount for user: ' + reloadDto.userId };
    }
    async paymentWithCredits(paywithCreditsDto) {
        const result = await this.paymentService.payWithCredits(paywithCreditsDto.userId, paywithCreditsDto.orderId, paywithCreditsDto.amount, paywithCreditsDto.paymentType);
        return { data: result, message: 'Payment with Credits for user: ' + paywithCreditsDto.userId };
    }
    async handleBillplzCallback(callbackData) {
        console.log('call back triggered :: ', callbackData);
        if (callbackData.paid) {
            try {
                await this.creditService.addCredit(callbackData);
                return { status: 'Payment recorded' };
            }
            catch (error) {
                return { status: 'Error recording payment', error: error.message };
            }
        }
        else {
            return { status: 'Payment not completed' };
        }
    }
    async handleBillplzRedirectUrl(query, res) {
        const decodedParams = Object.keys(query).reduce((acc, key) => {
            const decodedKey = decodeURIComponent(key);
            acc[decodedKey] = query[key];
            return acc;
        }, {});
        if (decodedParams['billplz']['paid']?.trim() === "true") {
            res.redirect('/payment/transaction-success?id=' + decodedParams['billplz']['id'] + '&paid_at=' + decodedParams['billplz']['paid_at']);
        }
        else {
            res.redirect('/payment/transaction-failed?id=' + decodedParams['billplz']['id'] + '&paid_at=' + decodedParams['billplz']['paid_at']);
        }
    }
    transactionSuccess(successRequestDto, res) {
        const { id, paid, paid_at } = successRequestDto;
        const receiptHtml = `
            <!DOCTYPE html>
            <html lang="en">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Transaction Success</title>
                <style>
                body {
                    font-family: Arial, sans-serif;
                    background-color: #f5f5f5;
                    margin: 0;
                    padding: 20px;
                }
                .container {
                    max-width: 600px;
                    margin: 0 auto;
                    background-color: #fff;
                    padding: 20px;
                    border-radius: 8px;
                    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
                }
                h1 {
                    color: #4CAF50;
                }
                .receipt {
                    margin-top: 20px;
                }
                .receipt-item {
                    margin-bottom: 10px;
                }
                .receipt-item span {
                    display: inline-block;
                    width: 150px;
                    font-weight: bold;
                }
                </style>
            </head>
            <body>
                <div class="container">
                <h1>Transaction Successful</h1>
                <p>Thank you for your payment. Your transaction was successful.</p>
                <div class="receipt">
                    <div class="receipt-item">
                    <span>Transaction ID:</span> ${id}
                    </div>

                    <div class="receipt-item">
                    <span>Date:</span> ${paid_at}
                    </div>
                </div>
                </div>
            </body>
            </html>
         `;
        res.send(receiptHtml);
    }
    transactionFailed(query, res) {
        const { id, paid, paid_at } = query;
        const failureHtml = `
          <!DOCTYPE html>
          <html lang="en">
          <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Transaction Failed</title>
            <style>
              body {
                font-family: Arial, sans-serif;
                background-color: #f5f5f5;
                margin: 0;
                padding: 20px;
              }
              .container {
                max-width: 600px;
                margin: 0 auto;
                background-color: #fff;
                padding: 20px;
                border-radius: 8px;
                box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
              }
              h1 {
                color: #f44336;
              }
            </style>
          </head>
          <body>
            <div class="container">
              <h1>Transaction Failed</h1>
              <p>Unfortunately, your transaction could not be completed. Please try again.</p>
              <div class="receipt">
                    <div class="receipt-item">
                    <span>Transaction ID:</span> ${id}
                    </div>
                </div>
            </div>
          </body>
          </html>
        `;
        res.send(failureHtml);
    }
};
exports.PaymentController = PaymentController;
__decorate([
    (0, common_1.Post)('reload'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [payment_dto_1.ReloadDto]),
    __metadata("design:returntype", Promise)
], PaymentController.prototype, "reload", null);
__decorate([
    (0, common_1.Post)('credit'),
    (0, common_1.HttpCode)(common_1.HttpStatus.OK),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [payment_dto_1.PaywithCreditsDto]),
    __metadata("design:returntype", Promise)
], PaymentController.prototype, "paymentWithCredits", null);
__decorate([
    (0, common_1.Post)('billplz/callback'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [payment_dto_1.BillplzCallbackDto]),
    __metadata("design:returntype", Promise)
], PaymentController.prototype, "handleBillplzCallback", null);
__decorate([
    (0, common_1.Get)('result'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", Promise)
], PaymentController.prototype, "handleBillplzRedirectUrl", null);
__decorate([
    (0, common_1.Get)('transaction-success'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], PaymentController.prototype, "transactionSuccess", null);
__decorate([
    (0, common_1.Get)('transaction-failed'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, Object]),
    __metadata("design:returntype", void 0)
], PaymentController.prototype, "transactionFailed", null);
exports.PaymentController = PaymentController = __decorate([
    (0, swagger_1.ApiTags)('payment'),
    (0, common_1.Controller)('payment'),
    __metadata("design:paramtypes", [payment_service_1.PaymentService,
        credit_service_1.CreditService])
], PaymentController);
//# sourceMappingURL=payment.controller.js.map