"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentService = void 0;
const axios_1 = require("@nestjs/axios");
const common_1 = require("@nestjs/common");
const rxjs_1 = require("rxjs");
const prisma_1 = require("../prisma");
const BillplzConfig_1 = require("./config/BillplzConfig");
const membership_dto_1 = require("../membership/membership.dto");
const credit_dto_1 = require("../credit/credit.dto");
let PaymentService = class PaymentService {
    constructor(config, httpService) {
        this.config = config;
        this.httpService = httpService;
        this.apiKey = config.apiKey;
        this.collectionId = config.collectionId;
        this.billplzBaseUrl = config.billplzBaseUrl;
    }
    async payWithCredits(userId, orderId, amount, paymentType = membership_dto_1.TransactionType.PURCHASE) {
        const walletData = await prisma_1.default.credit.findUnique({
            where: {
                userId
            }
        });
        if (amount > walletData.balance) {
            return "Insufficient Funds";
        }
        const order = await prisma_1.default.order.findUnique({
            where: { id: orderId },
        });
        if (!order) {
            return "No Order data";
        }
        const transaction = await prisma_1.default.transaction.create({
            data: {
                totalAmount: amount,
                paymentTime: new Date(),
                paymentMethod: paymentType,
                createdAt: new Date(),
                orderId: order.id
            }
        });
        if (transaction) {
            const order = prisma_1.default.order.update({
                where: { id: orderId },
                data: {
                    transactionId: transaction.id
                }
            });
            await prisma_1.default.creditHistory.create({
                data: {
                    amount: amount,
                    actualAmount: amount,
                    type: paymentType,
                    orderId: orderId,
                    creditId: walletData.id,
                    status: credit_dto_1.PaymentType.PAID,
                    lastCreditAmount: walletData.balance,
                    createdAt: new Date(),
                    updatedAt: new Date(),
                },
            });
            const updatedCreditData = await prisma_1.default.credit.update({
                data: {
                    balance: (walletData.balance - amount)
                },
                where: {
                    userId
                }
            });
        }
        return "Payment recorded";
    }
    async createBillplzPaymentRequest(userId, amount, orderId) {
        try {
            const user = await prisma_1.default.user.findUnique({
                where: {
                    id: userId
                }
            });
            const response = await (0, rxjs_1.firstValueFrom)(this.httpService.post(`${this.billplzBaseUrl}/bills`, {
                collection_id: this.collectionId,
                email: user.email,
                name: user.name,
                amount: amount * 100,
                callback_url: process.env.BILLPLZ_CALLBACK_URL,
                redirect_url: process.env.BILLPLZ_REDIRECT_URL,
                description: 'Top up credit',
            }, {
                auth: {
                    username: this.apiKey,
                    password: '',
                },
            }));
            return response.data;
        }
        catch (error) {
            return { error: "Error During calling to Billplz API via Reload API :: " + error.response };
        }
    }
};
exports.PaymentService = PaymentService;
exports.PaymentService = PaymentService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(BillplzConfig_1.BILLPLZ_CONFIG)),
    __metadata("design:paramtypes", [Object, axios_1.HttpService])
], PaymentService);
//# sourceMappingURL=payment.service.js.map