import { CreateUpdateRatingDto } from './rating.dto';
import { RatingService } from './rating.service';
export declare class RatingController {
    private RatingService;
    constructor(RatingService: RatingService);
    create(reqData: CreateUpdateRatingDto): Promise<{
        data: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        };
        message: string;
    }>;
    findAll(): Promise<{
        data: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        }[];
        message: string;
    }>;
    findOne(id: string): Promise<{
        data: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        };
        message: string;
    }>;
    update(id: string, reqData: CreateUpdateRatingDto): Promise<{
        data: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        };
        message: string;
    }>;
    remove(id: string): Promise<{
        data: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        };
        message: string;
    }>;
}
