"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RatingService = void 0;
const common_1 = require("@nestjs/common");
const prisma_1 = require("../prisma");
let RatingService = class RatingService {
    constructor() { }
    async create(data) {
        return prisma_1.default.rating.create({
            data: {
                merchantId: data.merchantId,
                reviewerId: data.reviewerId,
                rating: data.rating,
                review: data.review
            }
        });
    }
    async findAll() {
        return prisma_1.default.rating.findMany();
    }
    async findOne(id) {
        return prisma_1.default.rating.findUnique({ where: { id } });
    }
    async update(id, data) {
        return prisma_1.default.rating.update({
            where: { id },
            data: {
                merchantId: data.merchantId,
                rating: data.rating,
                review: data.review
            }
        });
    }
    async remove(id) {
        return prisma_1.default.rating.delete({ where: { id } });
    }
};
exports.RatingService = RatingService;
exports.RatingService = RatingService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], RatingService);
//# sourceMappingURL=rating.service.js.map