import { CreateUpdateTransactionDto } from './transaction.dto';
import { TransactionService } from './transaction.service';
export declare class TransactionController {
    private transactionService;
    constructor(transactionService: TransactionService);
    create(reqData: CreateUpdateTransactionDto): Promise<{
        data: {
            id: string;
            totalAmount: number;
            paymentTime: Date;
            paymentMethod: string;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
        };
        message: string;
    }>;
    findAll(): Promise<{
        data: {
            id: string;
            totalAmount: number;
            paymentTime: Date;
            paymentMethod: string;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
        }[];
        message: string;
    }>;
    findOne(id: string): Promise<{
        data: {
            id: string;
            totalAmount: number;
            paymentTime: Date;
            paymentMethod: string;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
        };
        message: string;
    }>;
    update(id: string, reqData: CreateUpdateTransactionDto): Promise<{
        data: {
            id: string;
            totalAmount: number;
            paymentTime: Date;
            paymentMethod: string;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
        };
        message: string;
    }>;
    remove(id: string): Promise<{
        data: {
            id: string;
            totalAmount: number;
            paymentTime: Date;
            paymentMethod: string;
            createdAt: Date;
            updatedAt: Date | null;
            orderId: string;
        };
        message: string;
    }>;
}
