import { CreateUpdateTransactionDto } from './transaction.dto';
export declare class TransactionService {
    constructor();
    create(data: CreateUpdateTransactionDto): Promise<{
        id: string;
        totalAmount: number;
        paymentTime: Date;
        paymentMethod: string;
        createdAt: Date;
        updatedAt: Date | null;
        orderId: string;
    }>;
    findAll(): Promise<{
        id: string;
        totalAmount: number;
        paymentTime: Date;
        paymentMethod: string;
        createdAt: Date;
        updatedAt: Date | null;
        orderId: string;
    }[]>;
    findOne(id: string): Promise<{
        id: string;
        totalAmount: number;
        paymentTime: Date;
        paymentMethod: string;
        createdAt: Date;
        updatedAt: Date | null;
        orderId: string;
    }>;
    update(id: string, data: CreateUpdateTransactionDto): Promise<{
        id: string;
        totalAmount: number;
        paymentTime: Date;
        paymentMethod: string;
        createdAt: Date;
        updatedAt: Date | null;
        orderId: string;
    }>;
    remove(id: string): Promise<{
        id: string;
        totalAmount: number;
        paymentTime: Date;
        paymentMethod: string;
        createdAt: Date;
        updatedAt: Date | null;
        orderId: string;
    }>;
}
