import { CreateUpdateUserDto, UpdateVehicleDto, UserImgUploadDto } from './user.dto';
import { UserService } from './user.service';
export declare class UserController {
    private userService;
    constructor(userService: UserService);
    create(reqData: CreateUpdateUserDto): Promise<{
        data: {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        };
        message: string;
    }>;
    findAll(): Promise<{
        data: ({
            userVehicle: {
                id: string;
                plate: string;
                userId: string;
                createdAt: Date;
                updatedAt: Date | null;
            }[];
            merchant: {
                id: string;
                name: string;
                image: string | null;
                businessType: string;
                businessRegistrationNumber: string | null;
                contractSigneeName: string | null;
                contractSigneeNRIC: string | null;
                openingHours: string | null;
                userId: string;
                addressId: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date | null;
                storyDescription: string | null;
            };
            address: {
                id: string;
                address: string;
                city: string;
                state: string;
                country: string;
                postalCode: string;
                latitude: number | null;
                longitude: number | null;
                createdAt: Date;
                updatedAt: Date;
            };
            role: {
                id: string;
                name: string;
                createdAt: Date;
                updatedAt: Date | null;
            };
            reviews: {
                id: string;
                rating: number;
                review: string;
                createdAt: Date;
                updatedAt: Date | null;
                merchantId: string;
                reviewerId: string;
                orderId: string | null;
            }[];
        } & {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        })[];
        message: string;
    }>;
    findOne(id: string): Promise<{
        data: {
            userVehicle: {
                id: string;
                plate: string;
                userId: string;
                createdAt: Date;
                updatedAt: Date | null;
            }[];
            merchant: {
                id: string;
                name: string;
                image: string | null;
                businessType: string;
                businessRegistrationNumber: string | null;
                contractSigneeName: string | null;
                contractSigneeNRIC: string | null;
                openingHours: string | null;
                userId: string;
                addressId: string | null;
                active: boolean;
                createdAt: Date;
                updatedAt: Date | null;
                storyDescription: string | null;
            };
            address: {
                id: string;
                address: string;
                city: string;
                state: string;
                country: string;
                postalCode: string;
                latitude: number | null;
                longitude: number | null;
                createdAt: Date;
                updatedAt: Date;
            };
            role: {
                id: string;
                name: string;
                createdAt: Date;
                updatedAt: Date | null;
            };
            reviews: {
                id: string;
                rating: number;
                review: string;
                createdAt: Date;
                updatedAt: Date | null;
                merchantId: string;
                reviewerId: string;
                orderId: string | null;
            }[];
        } & {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        };
        message: string;
    }>;
    update(id: string, reqData: CreateUpdateUserDto): Promise<{
        data: {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        };
        message: string;
    }>;
    updateVehicle(id: string, reqData: UpdateVehicleDto): Promise<{
        data: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        } | ({
            userVehicle: {
                id: string;
                plate: string;
                userId: string;
                createdAt: Date;
                updatedAt: Date | null;
            }[];
        } & {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        });
        message: string;
    }>;
    remove(id: string): Promise<{
        data: {
            id: string;
            email: string;
            name: string;
            roleId: string;
            phoneNumber: string;
            dateOfBirth: Date;
            addressId: string | null;
            profilePic: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date;
            membershipTierId: string | null;
            creditId: string | null;
            loyaltyPointId: string | null;
        };
        message: string;
    }>;
    uploadMenuImg(imagefile: Express.Multer.File, reqData: UserImgUploadDto): Promise<{
        data: string;
        message: string;
    }>;
}
