import { CreateUpdateUserDto, UpdateVehicleDto, UserImgUploadDto } from './user.dto';
export declare class UserService {
    constructor();
    create(data: CreateUpdateUserDto): Promise<{
        id: string;
        email: string;
        name: string;
        roleId: string;
        phoneNumber: string;
        dateOfBirth: Date;
        addressId: string | null;
        profilePic: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
        creditId: string | null;
        loyaltyPointId: string | null;
    }>;
    findAll(): Promise<({
        userVehicle: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        }[];
        merchant: {
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            openingHours: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        };
        address: {
            id: string;
            address: string;
            city: string;
            state: string;
            country: string;
            postalCode: string;
            latitude: number | null;
            longitude: number | null;
            createdAt: Date;
            updatedAt: Date;
        };
        role: {
            id: string;
            name: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        reviews: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        }[];
    } & {
        id: string;
        email: string;
        name: string;
        roleId: string;
        phoneNumber: string;
        dateOfBirth: Date;
        addressId: string | null;
        profilePic: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
        creditId: string | null;
        loyaltyPointId: string | null;
    })[]>;
    findOne(id: string): Promise<{
        userVehicle: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        }[];
        merchant: {
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            openingHours: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        };
        address: {
            id: string;
            address: string;
            city: string;
            state: string;
            country: string;
            postalCode: string;
            latitude: number | null;
            longitude: number | null;
            createdAt: Date;
            updatedAt: Date;
        };
        role: {
            id: string;
            name: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        reviews: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        }[];
    } & {
        id: string;
        email: string;
        name: string;
        roleId: string;
        phoneNumber: string;
        dateOfBirth: Date;
        addressId: string | null;
        profilePic: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
        creditId: string | null;
        loyaltyPointId: string | null;
    }>;
    findOneByEmail(email: string): Promise<{
        userVehicle: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        }[];
        merchant: {
            id: string;
            name: string;
            image: string | null;
            businessType: string;
            businessRegistrationNumber: string | null;
            contractSigneeName: string | null;
            contractSigneeNRIC: string | null;
            openingHours: string | null;
            userId: string;
            addressId: string | null;
            active: boolean;
            createdAt: Date;
            updatedAt: Date | null;
            storyDescription: string | null;
        };
        address: {
            id: string;
            address: string;
            city: string;
            state: string;
            country: string;
            postalCode: string;
            latitude: number | null;
            longitude: number | null;
            createdAt: Date;
            updatedAt: Date;
        };
        role: {
            id: string;
            name: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        reviews: {
            id: string;
            rating: number;
            review: string;
            createdAt: Date;
            updatedAt: Date | null;
            merchantId: string;
            reviewerId: string;
            orderId: string | null;
        }[];
    } & {
        id: string;
        email: string;
        name: string;
        roleId: string;
        phoneNumber: string;
        dateOfBirth: Date;
        addressId: string | null;
        profilePic: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
        creditId: string | null;
        loyaltyPointId: string | null;
    }>;
    update(id: string, data: CreateUpdateUserDto): Promise<{
        id: string;
        email: string;
        name: string;
        roleId: string;
        phoneNumber: string;
        dateOfBirth: Date;
        addressId: string | null;
        profilePic: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
        creditId: string | null;
        loyaltyPointId: string | null;
    }>;
    updateVehicle(id: string, data: UpdateVehicleDto): Promise<{
        id: string;
        plate: string;
        userId: string;
        createdAt: Date;
        updatedAt: Date | null;
    } | ({
        userVehicle: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        }[];
    } & {
        id: string;
        email: string;
        name: string;
        roleId: string;
        phoneNumber: string;
        dateOfBirth: Date;
        addressId: string | null;
        profilePic: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
        creditId: string | null;
        loyaltyPointId: string | null;
    })>;
    remove(id: string): Promise<{
        id: string;
        email: string;
        name: string;
        roleId: string;
        phoneNumber: string;
        dateOfBirth: Date;
        addressId: string | null;
        profilePic: string | null;
        active: boolean;
        createdAt: Date;
        updatedAt: Date;
        membershipTierId: string | null;
        creditId: string | null;
        loyaltyPointId: string | null;
    }>;
    uploadMenuImage(file: Express.Multer.File, data: UserImgUploadDto): Promise<string>;
}
