"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserService = void 0;
const common_1 = require("@nestjs/common");
const prisma_1 = require("../prisma");
const utils_1 = require("../utils");
let UserService = class UserService {
    constructor() { }
    async create(data) {
        const role = await prisma_1.default.role.findFirst({
            where: {
                name: data.role
            }
        });
        if (!role) {
            throw new Error('Role Customer Not Found');
        }
        return prisma_1.default.user.create({
            data: {
                email: data.email,
                name: data.name,
                phoneNumber: data.phoneNumber,
                dateOfBirth: new Date(data.dateOfBirth),
                role: {
                    connect: {
                        id: role.id
                    }
                },
                address: {
                    create: {
                        address: "",
                        city: "",
                        state: "",
                        country: "",
                        postalCode: ""
                    }
                }
            }
        });
    }
    async findAll() {
        return prisma_1.default.user.findMany({
            include: {
                address: true,
                merchant: true,
                role: true,
                userVehicle: true,
                reviews: true
            }
        });
    }
    async findOne(id) {
        return prisma_1.default.user.findUnique({
            where: { id },
            include: {
                address: true,
                merchant: true,
                role: true,
                userVehicle: true,
                reviews: true
            }
        });
    }
    async findOneByEmail(email) {
        return prisma_1.default.user.findUnique({
            where: { email },
            include: {
                address: true,
                merchant: true,
                role: true,
                userVehicle: true,
                reviews: true
            }
        });
    }
    async update(id, data) {
        const user = await prisma_1.default.user.findUnique({
            where: { id },
            include: {
                address: true
            }
        });
        return prisma_1.default.user.update({
            where: { id },
            data: {
                email: data.email,
                name: data.name,
                phoneNumber: data.phoneNumber,
                dateOfBirth: new Date(data.dateOfBirth)
            }
        });
    }
    async updateVehicle(id, data) {
        if (data.id) {
            await prisma_1.default.userVehicle.update({
                where: { id: data.id },
                data: {
                    plate: data.plate
                }
            });
            return await prisma_1.default.userVehicle.findUnique({
                where: { id: data.id }
            });
        }
        else {
            await prisma_1.default.user.update({
                where: { id },
                data: {
                    userVehicle: {
                        create: {
                            plate: data.plate
                        }
                    }
                }
            });
            return await prisma_1.default.user.findUnique({
                where: { id },
                include: {
                    userVehicle: true
                }
            });
        }
    }
    async remove(id) {
        return prisma_1.default.user.delete({ where: { id } });
    }
    async uploadMenuImage(file, data) {
        const UploadFunction = new utils_1.UploadImg();
        const publicurl = await UploadFunction.uploadimage("userprofilepic", data.userId, file);
        await prisma_1.default.user.update({
            where: { id: data.userId },
            data: {
                profilePic: publicurl.data.publicUrl
            }
        });
        return publicurl.data.publicUrl;
    }
};
exports.UserService = UserService;
exports.UserService = UserService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], UserService);
//# sourceMappingURL=user.service.js.map