"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadImg = void 0;
exports.calculateMerchantRating = calculateMerchantRating;
exports.calculateDistanceBetweenMerchantandUser = calculateDistanceBetweenMerchantandUser;
exports.isEmpty = isEmpty;
exports.generateReferenceId = generateReferenceId;
const common_1 = require("@nestjs/common");
const supabase_js_1 = require("@supabase/supabase-js");
const crypto_1 = require("crypto");
const fs = require("fs");
const util_1 = require("util");
const readFileAsync = (0, util_1.promisify)(fs.readFile);
function calculateMerchantRating(rating) {
    return rating.reduce((total, elem) => total + (elem.rating || 0), 0);
}
function calculateDistanceBetweenMerchantandUser(lat1, lon1, lat2, lon2) {
    const R = 6371;
    const dLat = (lat2 - lat1) * (Math.PI / 180);
    const dLon = (lon2 - lon1) * (Math.PI / 180);
    const a = Math.sin(dLat / 2) * Math.sin(dLat / 2) +
        Math.cos((lat1) * (Math.PI / 180)) * Math.cos((lat2) * (Math.PI / 180)) *
            Math.sin(dLon / 2) * Math.sin(dLon / 2);
    const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
    const distance = R * c;
    return distance;
}
let UploadImg = class UploadImg {
    constructor() {
        this.supabase = (0, supabase_js_1.createClient)(process.env.SUPABASE_URL, process.env.ROW_LEVEL_SECURITY_KEY);
    }
    async checkImageExists(bucketName, folderName, imageName) {
        const { data: objects, error } = await this.supabase.storage.from(bucketName).list(folderName);
        if (error) {
            throw error;
        }
        return objects.some(object => object.name === imageName);
    }
    async convertFileToBase64(file) {
        const base64String = file.buffer.toString('base64');
        return { mimetype: file.mimetype, base64String: base64String };
    }
    async uploadimage(filename, imagename, file) {
        const checkImageExists = await this.checkImageExists("image", filename, imagename);
        if (checkImageExists) {
            await this.supabase.storage.from('image').remove([`${filename}/${imagename}`]);
        }
        const { mimetype, base64String } = await this.convertFileToBase64(file);
        const base64Data = base64String.replace(/^data:image\/\w+;base64,/, '');
        const buffer = Buffer.from(base64Data, 'base64');
        const { data, error } = await this.supabase.storage.from('image').upload(`${filename}/${imagename}`, buffer, {
            contentType: mimetype
        });
        if (error) {
            throw error;
        }
        const key = data.path;
        const publicUrl = this.supabase.storage.from('image').getPublicUrl(`${filename}/${imagename}`);
        return publicUrl;
    }
};
exports.UploadImg = UploadImg;
exports.UploadImg = UploadImg = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], UploadImg);
function isEmpty(value) {
    return (value === null ||
        value === undefined ||
        (typeof value === 'string' && value.trim().length === 0) ||
        (Array.isArray(value) && value.length === 0) ||
        (typeof value === 'object' && Object.keys(value).length === 0));
}
function generateReferenceId() {
    const now = new Date();
    const year = now.getFullYear().toString().slice(-2);
    const month = String(now.getMonth() + 1).padStart(2, '0');
    const day = String(now.getDate()).padStart(2, '0');
    const datePrefix = `${year}${month}${day}`;
    const randomSuffix = (0, crypto_1.randomBytes)(4).toString('hex');
    return `ORD-${datePrefix}-${randomSuffix}`;
}
//# sourceMappingURL=utils.js.map