import { CreateUpdateVehicleDto } from './vehicle.dto';
import { VehicleService } from './vehicle.service';
export declare class VehicleController {
    private vehicleService;
    constructor(vehicleService: VehicleService);
    create(reqData: CreateUpdateVehicleDto): Promise<{
        data: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        message: string;
    }>;
    findAll(): Promise<{
        data: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        }[];
        message: string;
    }>;
    findOne(id: string): Promise<{
        data: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        message: string;
    }>;
    update(id: string, reqData: CreateUpdateVehicleDto): Promise<{
        data: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        message: string;
    }>;
    remove(id: string): Promise<{
        data: {
            id: string;
            plate: string;
            userId: string;
            createdAt: Date;
            updatedAt: Date | null;
        };
        message: string;
    }>;
}
