export type ReadonlyDeep<O> = {
    +readonly [K in keyof O]: ReadonlyDeep<O[K]>;
};
export declare namespace DMMF {
    type Document = ReadonlyDeep<{
        datamodel: Datamodel;
        schema: Schema;
        mappings: Mappings;
    }>;
    type Mappings = ReadonlyDeep<{
        modelOperations: ModelMapping[];
        otherOperations: {
            read: string[];
            write: string[];
        };
    }>;
    type OtherOperationMappings = ReadonlyDeep<{
        read: string[];
        write: string[];
    }>;
    type DatamodelEnum = ReadonlyDeep<{
        name: string;
        values: EnumValue[];
        dbName?: string | null;
        documentation?: string;
    }>;
    type SchemaEnum = ReadonlyDeep<{
        name: string;
        values: string[];
    }>;
    type EnumValue = ReadonlyDeep<{
        name: string;
        dbName: string | null;
    }>;
    type Datamodel = ReadonlyDeep<{
        models: Model[];
        enums: DatamodelEnum[];
        types: Model[];
    }>;
    type uniqueIndex = ReadonlyDeep<{
        name: string;
        fields: string[];
    }>;
    type PrimaryKey = ReadonlyDeep<{
        name: string | null;
        fields: string[];
    }>;
    type Model = ReadonlyDeep<{
        name: string;
        dbName: string | null;
        fields: Field[];
        uniqueFields: string[][];
        uniqueIndexes: uniqueIndex[];
        documentation?: string;
        primaryKey: PrimaryKey | null;
        isGenerated?: boolean;
    }>;
    type FieldKind = 'scalar' | 'object' | 'enum' | 'unsupported';
    type FieldNamespace = 'model' | 'prisma';
    type FieldLocation = 'scalar' | 'inputObjectTypes' | 'outputObjectTypes' | 'enumTypes' | 'fieldRefTypes';
    type Field = ReadonlyDeep<{
        kind: FieldKind;
        name: string;
        isRequired: boolean;
        isList: boolean;
        isUnique: boolean;
        isId: boolean;
        isReadOnly: boolean;
        isGenerated?: boolean;
        isUpdatedAt?: boolean;
        /**
         * Describes the data type in the same the way it is defined in the Prisma schema:
         * BigInt, Boolean, Bytes, DateTime, Decimal, Float, Int, JSON, String, $ModelName
         */
        type: string;
        dbName?: string | null;
        hasDefaultValue: boolean;
        default?: FieldDefault | FieldDefaultScalar | FieldDefaultScalar[];
        relationFromFields?: string[];
        relationToFields?: string[];
        relationOnDelete?: string;
        relationName?: string;
        documentation?: string;
    }>;
    type FieldDefault = ReadonlyDeep<{
        name: string;
        args: any[];
    }>;
    type FieldDefaultScalar = string | boolean | number;
    type Schema = ReadonlyDeep<{
        rootQueryType?: string;
        rootMutationType?: string;
        inputObjectTypes: {
            model?: InputType[];
            prisma: InputType[];
        };
        outputObjectTypes: {
            model: OutputType[];
            prisma: OutputType[];
        };
        enumTypes: {
            model?: SchemaEnum[];
            prisma: SchemaEnum[];
        };
        fieldRefTypes: {
            prisma?: FieldRefType[];
        };
    }>;
    type Query = ReadonlyDeep<{
        name: string;
        args: SchemaArg[];
        output: QueryOutput;
    }>;
    type QueryOutput = ReadonlyDeep<{
        name: string;
        isRequired: boolean;
        isList: boolean;
    }>;
    type TypeRef<AllowedLocations extends FieldLocation> = {
        isList: boolean;
        type: string;
        location: AllowedLocations;
        namespace?: FieldNamespace;
    };
    type InputTypeRef = TypeRef<'scalar' | 'inputObjectTypes' | 'enumTypes' | 'fieldRefTypes'>;
    type SchemaArg = ReadonlyDeep<{
        name: string;
        comment?: string;
        isNullable: boolean;
        isRequired: boolean;
        inputTypes: InputTypeRef[];
        deprecation?: Deprecation;
    }>;
    type OutputType = ReadonlyDeep<{
        name: string;
        fields: SchemaField[];
    }>;
    type SchemaField = ReadonlyDeep<{
        name: string;
        isNullable?: boolean;
        outputType: OutputTypeRef;
        args: SchemaArg[];
        deprecation?: Deprecation;
        documentation?: string;
    }>;
    type OutputTypeRef = TypeRef<'scalar' | 'outputObjectTypes' | 'enumTypes'>;
    type Deprecation = ReadonlyDeep<{
        sinceVersion: string;
        reason: string;
        plannedRemovalVersion?: string;
    }>;
    type InputType = ReadonlyDeep<{
        name: string;
        constraints: {
            maxNumFields: number | null;
            minNumFields: number | null;
            fields?: string[];
        };
        meta?: {
            source?: string;
        };
        fields: SchemaArg[];
    }>;
    type FieldRefType = ReadonlyDeep<{
        name: string;
        allowTypes: FieldRefAllowType[];
        fields: SchemaArg[];
    }>;
    type FieldRefAllowType = TypeRef<'scalar' | 'enumTypes'>;
    type ModelMapping = ReadonlyDeep<{
        model: string;
        plural: string;
        findUnique?: string | null;
        findUniqueOrThrow?: string | null;
        findFirst?: string | null;
        findFirstOrThrow?: string | null;
        findMany?: string | null;
        create?: string | null;
        createMany?: string | null;
        createManyAndReturn?: string | null;
        update?: string | null;
        updateMany?: string | null;
        upsert?: string | null;
        delete?: string | null;
        deleteMany?: string | null;
        aggregate?: string | null;
        groupBy?: string | null;
        count?: string | null;
        findRaw?: string | null;
        aggregateRaw?: string | null;
    }>;
    enum ModelAction {
        findUnique = "findUnique",
        findUniqueOrThrow = "findUniqueOrThrow",
        findFirst = "findFirst",
        findFirstOrThrow = "findFirstOrThrow",
        findMany = "findMany",
        create = "create",
        createMany = "createMany",
        createManyAndReturn = "createManyAndReturn",
        update = "update",
        updateMany = "updateMany",
        upsert = "upsert",
        delete = "delete",
        deleteMany = "deleteMany",
        groupBy = "groupBy",
        count = "count",// TODO: count does not actually exist, why?
        aggregate = "aggregate",
        findRaw = "findRaw",
        aggregateRaw = "aggregateRaw"
    }
}
