import type { DMMF } from './dmmf';
export declare namespace JsonRPC {
    type Request = {
        jsonrpc: '2.0';
        method: string;
        params?: any;
        id: number;
    };
    type Response = SuccessResponse | ErrorResponse;
    type SuccessResponse = {
        jsonrpc: '2.0';
        result: any;
        id: number;
    };
    type ErrorResponse = {
        jsonrpc: '2.0';
        error: {
            code: number;
            message: string;
            data: any;
        };
        id: number;
    };
}
export interface GeneratorConfig {
    name: string;
    output: EnvValue | null;
    isCustomOutput?: boolean;
    provider: EnvValue;
    config: {
        /** `output` is a reserved name and will only be available directly at `generator.output` */
        output?: never;
        /** `provider` is a reserved name and will only be available directly at `generator.provider` */
        provider?: never;
        /** `binaryTargets` is a reserved name and will only be available directly at `generator.binaryTargets` */
        binaryTargets?: never;
        /** `previewFeatures` is a reserved name and will only be available directly at `generator.previewFeatures` */
        previewFeatures?: never;
    } & {
        [key: string]: string | string[] | undefined;
    };
    binaryTargets: BinaryTargetsEnvValue[];
    previewFeatures: string[];
    envPaths?: EnvPaths;
    sourceFilePath: string;
}
export interface EnvValue {
    fromEnvVar: null | string;
    value: null | string;
}
export interface BinaryTargetsEnvValue {
    fromEnvVar: string | null;
    value: string;
    native?: boolean;
}
export type ConnectorType = 'mysql' | 'mongodb' | 'sqlite' | 'postgresql' | 'postgres' | 'sqlserver' | 'cockroachdb';
export type ActiveConnectorType = Exclude<ConnectorType, 'postgres'>;
export interface DataSource {
    name: string;
    provider: ConnectorType;
    activeProvider: ActiveConnectorType;
    url: EnvValue;
    directUrl?: EnvValue;
    schemas: string[] | [];
    sourceFilePath: string;
}
export type BinaryPaths = {
    schemaEngine?: {
        [binaryTarget: string]: string;
    };
    queryEngine?: {
        [binaryTarget: string]: string;
    };
    libqueryEngine?: {
        [binaryTarget: string]: string;
    };
};
export type EnvPaths = {
    rootEnvPath: string | null;
    schemaEnvPath: string | undefined;
};
/** The options passed to the generator implementations */
export type GeneratorOptions = {
    generator: GeneratorConfig;
    otherGenerators: GeneratorConfig[];
    schemaPath: string;
    dmmf: DMMF.Document;
    datasources: DataSource[];
    datamodel: string;
    version: string;
    binaryPaths?: BinaryPaths;
    postinstall?: boolean;
    noEngine?: boolean;
    noHints?: boolean;
    allowNoModels?: boolean;
    envPaths?: EnvPaths;
};
export type EngineType = 'queryEngine' | 'libqueryEngine' | 'schemaEngine';
export type GeneratorManifest = {
    prettyName?: string;
    defaultOutput?: string;
    denylists?: {
        models?: string[];
        fields?: string[];
    };
    requiresGenerators?: string[];
    requiresEngines?: EngineType[];
    version?: string;
    requiresEngineVersion?: string;
};
