"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_22WWDCBL_exports = {};
__export(chunk_22WWDCBL_exports, {
  getEngineVersion: () => getEngineVersion,
  safeGetEngineVersion: () => safeGetEngineVersion
});
module.exports = __toCommonJS(chunk_22WWDCBL_exports);
var import_chunk_S4LINK5Y = require("./chunk-S4LINK5Y.js");
var import_chunk_7XNZDY2V = require("./chunk-7XNZDY2V.js");
var import_chunk_Z2NHAREC = require("./chunk-Z2NHAREC.js");
var import_chunk_JM6ICT4D = require("./chunk-JM6ICT4D.js");
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_engines = require("@prisma/engines");
var import_fetch_engine = require("@prisma/fetch-engine");
var import_get_platform = require("@prisma/get-platform");
var import_execa = (0, import_chunk_WWAWV7DQ.__toESM)((0, import_chunk_7XNZDY2V.require_execa)());
async function getEngineVersion(enginePath, binaryName) {
  if (!binaryName) {
    binaryName = (0, import_engines.getCliQueryEngineBinaryType)();
  }
  enginePath = await (0, import_chunk_Z2NHAREC.resolveBinary)(binaryName, enginePath);
  const platformInfo = await (0, import_get_platform.getPlatformInfo)();
  if (binaryName === import_fetch_engine.BinaryType.QueryEngineLibrary) {
    (0, import_get_platform.assertNodeAPISupported)();
    const QE = (0, import_chunk_S4LINK5Y.loadLibrary)(enginePath, platformInfo);
    return `${import_fetch_engine.BinaryType.QueryEngineLibrary} ${QE.version().commit}`;
  } else {
    const { stdout } = await (0, import_execa.default)(enginePath, ["--version"]);
    return stdout;
  }
}
function safeGetEngineVersion(enginePath, binaryName) {
  return (0, import_chunk_JM6ICT4D.tryCatch2)(
    () => getEngineVersion(enginePath, binaryName),
    (error) => error
  );
}
