"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_5DKK4SNW_exports = {};
__export(chunk_5DKK4SNW_exports, {
  getLintWarnings: () => getLintWarnings,
  getLintWarningsAsText: () => getLintWarningsAsText,
  handleLintPanic: () => handleLintPanic,
  lintSchema: () => lintSchema,
  warningToString: () => warningToString
});
module.exports = __toCommonJS(chunk_5DKK4SNW_exports);
var import_chunk_YRBRUREX = require("./chunk-YRBRUREX.js");
var import_chunk_C55GF762 = require("./chunk-C55GF762.js");
var import_chunk_A4QWQE3W = require("./chunk-A4QWQE3W.js");
var import_chunk_PG5FDKSF = require("./chunk-PG5FDKSF.js");
function lintSchema({ schemas }) {
  const lintResult = import_chunk_C55GF762.prismaSchemaWasm.lint(JSON.stringify(schemas));
  const lintDiagnostics = JSON.parse(lintResult);
  return lintDiagnostics;
}
function handleLintPanic(tryCb, { schemas }) {
  try {
    return tryCb();
  } catch (e) {
    const { message, stack } = (0, import_chunk_A4QWQE3W.getWasmError)(e);
    const panic = new import_chunk_A4QWQE3W.RustPanic(
      /* message */
      message,
      /* rustStack */
      stack,
      /* request */
      "@prisma/prisma-schema-wasm lint",
      "FMT_CLI",
      /* schemaPath */
      (0, import_chunk_YRBRUREX.debugMultipleSchemaPaths)(schemas),
      /* schema */
      schemas
    );
    throw panic;
  }
}
function getLintWarnings(lintDiagnostics) {
  return lintDiagnostics.filter(isWarning);
}
function getLintWarningsAsText(lintDiagnostics) {
  const lintWarnings = getLintWarnings(lintDiagnostics);
  const textLines = [];
  if (lintWarnings.length > 0) {
    textLines.push((0, import_chunk_PG5FDKSF.yellow)(`
Prisma schema warning${lintWarnings.length > 1 ? "s" : ""}:`));
    for (const warning of lintWarnings) {
      textLines.push(warningToString(warning));
    }
  }
  return textLines.join("\n");
}
function warningToString(warning) {
  return (0, import_chunk_PG5FDKSF.yellow)(`- ${warning.text}`);
}
function isWarning(diagnostic) {
  return diagnostic.is_warning;
}
