"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_5I4BOTBV_exports = {};
__export(chunk_5I4BOTBV_exports, {
  isCurrentBinInstalledGlobally: () => isCurrentBinInstalledGlobally
});
module.exports = __toCommonJS(chunk_5I4BOTBV_exports);
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_fs = __toESM(require("fs"));
var require_ini = (0, import_chunk_WWAWV7DQ.__commonJS)({
  "../../node_modules/.pnpm/ini@2.0.0/node_modules/ini/ini.js"(exports, module2) {
    "use strict";
    var { hasOwnProperty } = Object.prototype;
    var eol = typeof process !== "undefined" && process.platform === "win32" ? "\r\n" : "\n";
    var encode = (obj, opt) => {
      const children = [];
      let out = "";
      if (typeof opt === "string") {
        opt = {
          section: opt,
          whitespace: false
        };
      } else {
        opt = opt || /* @__PURE__ */ Object.create(null);
        opt.whitespace = opt.whitespace === true;
      }
      const separator = opt.whitespace ? " = " : "=";
      for (const k of Object.keys(obj)) {
        const val = obj[k];
        if (val && Array.isArray(val)) {
          for (const item of val)
            out += safe(k + "[]") + separator + safe(item) + "\n";
        } else if (val && typeof val === "object")
          children.push(k);
        else
          out += safe(k) + separator + safe(val) + eol;
      }
      if (opt.section && out.length)
        out = "[" + safe(opt.section) + "]" + eol + out;
      for (const k of children) {
        const nk = dotSplit(k).join("\\.");
        const section = (opt.section ? opt.section + "." : "") + nk;
        const { whitespace } = opt;
        const child = encode(obj[k], {
          section,
          whitespace
        });
        if (out.length && child.length)
          out += eol;
        out += child;
      }
      return out;
    };
    var dotSplit = (str) => str.replace(/\1/g, "LITERAL\\1LITERAL").replace(/\\\./g, "").split(/\./).map((part) => part.replace(/\1/g, "\\.").replace(/\2LITERAL\\1LITERAL\2/g, ""));
    var decode = (str) => {
      const out = /* @__PURE__ */ Object.create(null);
      let p = out;
      let section = null;
      const re = /^\[([^\]]*)\]$|^([^=]+)(=(.*))?$/i;
      const lines = str.split(/[\r\n]+/g);
      for (const line of lines) {
        if (!line || line.match(/^\s*[;#]/))
          continue;
        const match = line.match(re);
        if (!match)
          continue;
        if (match[1] !== void 0) {
          section = unsafe(match[1]);
          if (section === "__proto__") {
            p = /* @__PURE__ */ Object.create(null);
            continue;
          }
          p = out[section] = out[section] || /* @__PURE__ */ Object.create(null);
          continue;
        }
        const keyRaw = unsafe(match[2]);
        const isArray = keyRaw.length > 2 && keyRaw.slice(-2) === "[]";
        const key = isArray ? keyRaw.slice(0, -2) : keyRaw;
        if (key === "__proto__")
          continue;
        const valueRaw = match[3] ? unsafe(match[4]) : true;
        const value = valueRaw === "true" || valueRaw === "false" || valueRaw === "null" ? JSON.parse(valueRaw) : valueRaw;
        if (isArray) {
          if (!hasOwnProperty.call(p, key))
            p[key] = [];
          else if (!Array.isArray(p[key]))
            p[key] = [p[key]];
        }
        if (Array.isArray(p[key]))
          p[key].push(value);
        else
          p[key] = value;
      }
      const remove = [];
      for (const k of Object.keys(out)) {
        if (!hasOwnProperty.call(out, k) || typeof out[k] !== "object" || Array.isArray(out[k]))
          continue;
        const parts = dotSplit(k);
        let p2 = out;
        const l = parts.pop();
        const nl = l.replace(/\\\./g, ".");
        for (const part of parts) {
          if (part === "__proto__")
            continue;
          if (!hasOwnProperty.call(p2, part) || typeof p2[part] !== "object")
            p2[part] = /* @__PURE__ */ Object.create(null);
          p2 = p2[part];
        }
        if (p2 === out && nl === l)
          continue;
        p2[nl] = out[k];
        remove.push(k);
      }
      for (const del of remove)
        delete out[del];
      return out;
    };
    var isQuoted = (val) => val.charAt(0) === '"' && val.slice(-1) === '"' || val.charAt(0) === "'" && val.slice(-1) === "'";
    var safe = (val) => typeof val !== "string" || val.match(/[=\r\n]/) || val.match(/^\[/) || val.length > 1 && isQuoted(val) || val !== val.trim() ? JSON.stringify(val) : val.replace(/;/g, "\\;").replace(/#/g, "\\#");
    var unsafe = (val, doUnesc) => {
      val = (val || "").trim();
      if (isQuoted(val)) {
        if (val.charAt(0) === "'")
          val = val.substr(1, val.length - 2);
        try {
          val = JSON.parse(val);
        } catch (_) {
        }
      } else {
        let esc = false;
        let unesc = "";
        for (let i = 0, l = val.length; i < l; i++) {
          const c = val.charAt(i);
          if (esc) {
            if ("\\;#".indexOf(c) !== -1)
              unesc += c;
            else
              unesc += "\\" + c;
            esc = false;
          } else if (";#".indexOf(c) !== -1)
            break;
          else if (c === "\\")
            esc = true;
          else
            unesc += c;
        }
        if (esc)
          unesc += "\\";
        return unesc.trim();
      }
      return val;
    };
    module2.exports = {
      parse: decode,
      decode,
      stringify: encode,
      encode,
      safe,
      unsafe
    };
  }
});
var require_global_dirs = (0, import_chunk_WWAWV7DQ.__commonJS)({
  "../../node_modules/.pnpm/global-dirs@4.0.0/node_modules/global-dirs/index.js"(exports) {
    "use strict";
    var path = (0, import_chunk_WWAWV7DQ.__require)("path");
    var os = (0, import_chunk_WWAWV7DQ.__require)("os");
    var fs2 = (0, import_chunk_WWAWV7DQ.__require)("fs");
    var ini = require_ini();
    var isWindows = process.platform === "win32";
    var readRc = (filePath) => {
      try {
        return ini.parse(fs2.readFileSync(filePath, "utf8")).prefix;
      } catch {
      }
    };
    var getEnvNpmPrefix = () => {
      return Object.keys(process.env).reduce((prefix, name) => {
        return /^npm_config_prefix$/i.test(name) ? process.env[name] : prefix;
      }, void 0);
    };
    var getGlobalNpmrc = () => {
      if (isWindows && process.env.APPDATA) {
        return path.join(process.env.APPDATA, "/npm/etc/npmrc");
      }
      if (process.execPath.includes("/Cellar/node")) {
        const homebrewPrefix = process.execPath.slice(0, process.execPath.indexOf("/Cellar/node"));
        return path.join(homebrewPrefix, "/lib/node_modules/npm/npmrc");
      }
      if (process.execPath.endsWith("/bin/node")) {
        const installDir = path.dirname(path.dirname(process.execPath));
        return path.join(installDir, "/etc/npmrc");
      }
    };
    var getDefaultNpmPrefix = () => {
      if (isWindows) {
        const { APPDATA } = process.env;
        return APPDATA ? path.join(APPDATA, "npm") : path.dirname(process.execPath);
      }
      return path.dirname(path.dirname(process.execPath));
    };
    var getNpmPrefix = () => {
      const envPrefix = getEnvNpmPrefix();
      if (envPrefix) {
        return envPrefix;
      }
      const homePrefix = readRc(path.join(os.homedir(), ".npmrc"));
      if (homePrefix) {
        return homePrefix;
      }
      if (process.env.PREFIX) {
        return process.env.PREFIX;
      }
      const globalPrefix = readRc(getGlobalNpmrc());
      if (globalPrefix) {
        return globalPrefix;
      }
      return getDefaultNpmPrefix();
    };
    var npmPrefix = path.resolve(getNpmPrefix());
    var getYarnWindowsDirectory = () => {
      if (isWindows && process.env.LOCALAPPDATA) {
        const dir = path.join(process.env.LOCALAPPDATA, "Yarn");
        if (fs2.existsSync(dir)) {
          return dir;
        }
      }
      return false;
    };
    var getYarnPrefix = () => {
      if (process.env.PREFIX) {
        return process.env.PREFIX;
      }
      const windowsPrefix = getYarnWindowsDirectory();
      if (windowsPrefix) {
        return windowsPrefix;
      }
      const configPrefix = path.join(os.homedir(), ".config/yarn");
      if (fs2.existsSync(configPrefix)) {
        return configPrefix;
      }
      const homePrefix = path.join(os.homedir(), ".yarn-config");
      if (fs2.existsSync(homePrefix)) {
        return homePrefix;
      }
      return npmPrefix;
    };
    exports.npm = {};
    exports.npm.prefix = npmPrefix;
    exports.npm.packages = path.join(npmPrefix, isWindows ? "node_modules" : "lib/node_modules");
    exports.npm.binaries = isWindows ? npmPrefix : path.join(npmPrefix, "bin");
    var yarnPrefix = path.resolve(getYarnPrefix());
    exports.yarn = {};
    exports.yarn.prefix = yarnPrefix;
    exports.yarn.packages = path.join(yarnPrefix, getYarnWindowsDirectory() ? "Data/global/node_modules" : "global/node_modules");
    exports.yarn.binaries = path.join(exports.yarn.packages, ".bin");
  }
});
var import_global_dirs = (0, import_chunk_WWAWV7DQ.__toESM)(require_global_dirs());
function isCurrentBinInstalledGlobally() {
  try {
    const realPrismaPath = import_fs.default.realpathSync(process.argv[1]);
    const usingGlobalYarn = realPrismaPath.indexOf(import_global_dirs.default.yarn.packages) === 0;
    const usingGlobalNpm = realPrismaPath.indexOf(import_fs.default.realpathSync(import_global_dirs.default.npm.packages)) === 0;
    if (usingGlobalNpm) {
      return "npm";
    }
    if (usingGlobalYarn) {
      return "yarn";
    } else {
      false;
    }
  } catch (e) {
  }
  return false;
}
