"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_6HXOL3QF_exports = {};
__export(chunk_6HXOL3QF_exports, {
  getEnginesInfo: () => getEnginesInfo,
  getEnginesMetaInfo: () => getEnginesMetaInfo,
  resolveEngine: () => resolveEngine
});
module.exports = __toCommonJS(chunk_6HXOL3QF_exports);
var import_chunk_SMHAELKS = require("./chunk-SMHAELKS.js");
var import_chunk_22WWDCBL = require("./chunk-22WWDCBL.js");
var import_chunk_H3T4L34H = require("./chunk-H3T4L34H.js");
var import_chunk_Z2NHAREC = require("./chunk-Z2NHAREC.js");
var import_chunk_JM6ICT4D = require("./chunk-JM6ICT4D.js");
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_engines = require("@prisma/engines");
var import_fetch_engine = require("@prisma/fetch-engine");
var import_path = __toESM(require("path"));
var import_function2 = (0, import_chunk_WWAWV7DQ.__toESM)((0, import_chunk_SMHAELKS.require_function)());
var none2 = import_chunk_JM6ICT4D.none;
var some2 = import_chunk_JM6ICT4D.some;
var getRight = function(ma) {
  return ma._tag === "Left" ? none2 : some2(ma.right);
};
var _map = function(fa, f) {
  return (0, import_chunk_JM6ICT4D.pipe)(fa, map(f));
};
var _ap = function(fab, fa) {
  return (0, import_chunk_JM6ICT4D.pipe)(fab, ap(fa));
};
var URI = "Option";
var map = function(f) {
  return function(fa) {
    return isNone(fa) ? none2 : some2(f(fa.value));
  };
};
var Functor = {
  URI,
  map: _map
};
var as2 = (0, import_chunk_JM6ICT4D.dual)(2, (0, import_chunk_JM6ICT4D.as)(Functor));
var asUnit2 = (0, import_chunk_JM6ICT4D.asUnit)(Functor);
var ap = function(fa) {
  return function(fab) {
    return isNone(fab) ? none2 : isNone(fa) ? none2 : some2(fab.value(fa.value));
  };
};
var flatMap = /* @__PURE__ */ (0, import_chunk_JM6ICT4D.dual)(2, function(ma, f) {
  return isNone(ma) ? none2 : f(ma.value);
});
var Chain = {
  URI,
  map: _map,
  ap: _ap,
  chain: flatMap
};
var orElse = (0, import_chunk_JM6ICT4D.dual)(2, function(self, that) {
  return isNone(self) ? that() : self;
});
var fromEither2 = getRight;
var FromEither = {
  URI,
  fromEither: fromEither2
};
var isSome2 = import_chunk_JM6ICT4D.isSome;
var isNone = function(fa) {
  return fa._tag === "None";
};
var matchW = function(onNone, onSome) {
  return function(ma) {
    return isNone(ma) ? onNone() : onSome(ma.value);
  };
};
var match = matchW;
var fold = match;
var tap2 = /* @__PURE__ */ (0, import_chunk_JM6ICT4D.dual)(2, (0, import_chunk_JM6ICT4D.tap)(Chain));
var tapEither2 = /* @__PURE__ */ (0, import_chunk_JM6ICT4D.dual)(2, (0, import_chunk_JM6ICT4D.tapEither)(FromEither, Chain));
var fromNullable = function(a) {
  return a == null ? none2 : some2(a);
};
async function getEnginesMetaInfo() {
  const cliQueryEngineBinaryType = (0, import_engines.getCliQueryEngineBinaryType)();
  const engines = [
    {
      name: "query-engine",
      type: cliQueryEngineBinaryType
    },
    {
      name: "schema-engine",
      type: import_fetch_engine.BinaryType.SchemaEngineBinary
    }
  ];
  const enginePromises = engines.map(({ name, type }) => {
    return resolveEngine(type).then((result) => [name, result]);
  });
  const engineMatrix = await Promise.all(enginePromises).then(Object.fromEntries);
  const engineDataAcc = engines.map(({ name }) => {
    const [engineInfo, errors] = getEnginesInfo(engineMatrix[name]);
    return [{ [name]: engineInfo }, errors];
  });
  const engineMetaInfo = engineDataAcc.map((arr) => arr[0]);
  const enginesMetaInfoErrors = engineDataAcc.flatMap((arr) => arr[1]);
  return [engineMetaInfo, enginesMetaInfoErrors];
}
function getEnginesInfo(enginesInfo) {
  const errors = [];
  const resolved = (0, import_chunk_H3T4L34H.$)(enginesInfo).with({ fromEnvVar: import_chunk_H3T4L34H.N.when(isSome2) }, (_engineInfo) => {
    return `, resolved by ${_engineInfo.fromEnvVar.value}`;
  }).otherwise(() => "");
  const absolutePath = (0, import_chunk_H3T4L34H.$)(enginesInfo).with({ path: import_chunk_H3T4L34H.N.when(import_chunk_JM6ICT4D.isRight) }, (_engineInfo) => {
    return _engineInfo.path.right;
  }).with({ path: import_chunk_H3T4L34H.N.when(import_chunk_JM6ICT4D.isLeft) }, (_engineInfo) => {
    errors.push(_engineInfo.path.left);
    return "E_CANNOT_RESOLVE_PATH";
  }).exhaustive();
  const version = (0, import_chunk_H3T4L34H.$)(enginesInfo).with({ version: import_chunk_H3T4L34H.N.when(import_chunk_JM6ICT4D.isRight) }, (_engineInfo) => {
    return _engineInfo.version.right;
  }).with({ version: import_chunk_H3T4L34H.N.when(import_chunk_JM6ICT4D.isLeft) }, (_engineInfo) => {
    errors.push(_engineInfo.version.left);
    return "E_CANNOT_RESOLVE_VERSION";
  }).exhaustive();
  const versionMessage = `${version} (at ${import_path.default.relative(process.cwd(), absolutePath)}${resolved})`;
  return [versionMessage, errors];
}
async function resolveEngine(binaryName) {
  const pathFromEnvOption = fromNullable((0, import_fetch_engine.getBinaryEnvVarPath)(binaryName));
  const fromEnvVarOption = (0, import_function2.pipe)(
    pathFromEnvOption,
    map((p) => p.fromEnvVar)
  );
  const enginePathEither = await (0, import_function2.pipe)(
    pathFromEnvOption,
    fold(
      () => (0, import_chunk_Z2NHAREC.safeResolveBinary)(binaryName),
      (pathFromEnv) => (0, import_chunk_JM6ICT4D.right2)(pathFromEnv.path)
    )
  )();
  const versionEither = await (0, import_function2.pipe)(
    enginePathEither,
    import_chunk_JM6ICT4D.fromEither,
    (0, import_chunk_JM6ICT4D.chain)((enginePath) => {
      return (0, import_chunk_22WWDCBL.safeGetEngineVersion)(enginePath, binaryName);
    })
  )();
  const engineInfo = {
    path: enginePathEither,
    version: versionEither,
    fromEnvVar: fromEnvVarOption
  };
  return engineInfo;
}
