"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM2 = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_D4MCOTL5_exports = {};
__export(chunk_D4MCOTL5_exports, {
  getBinaryPathsByVersion: () => getBinaryPathsByVersion
});
module.exports = __toCommonJS(chunk_D4MCOTL5_exports);
var import_chunk_RS2R7COT = require("./chunk-RS2R7COT.js");
var import_chunk_4CGPN5SR = require("./chunk-4CGPN5SR.js");
var import_chunk_2SDPW6AX = require("./chunk-2SDPW6AX.js");
var import_chunk_7B5PXS6N = require("./chunk-7B5PXS6N.js");
var import_chunk_RQPDQSHK = require("./chunk-RQPDQSHK.js");
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_engines = require("@prisma/engines");
var import_fetch_engine = require("@prisma/fetch-engine");
var import_path = __toESM2(require("path"));
var import_fs_extra = (0, import_chunk_WWAWV7DQ.__toESM)((0, import_chunk_RQPDQSHK.require_lib)());
async function getBinaryPathsByVersion({
  neededVersions,
  binaryTarget,
  version,
  printDownloadProgress,
  skipDownload,
  binaryPathsOverride
}) {
  const binaryPathsByVersion = /* @__PURE__ */ Object.create(null);
  for (const currentVersion in neededVersions) {
    binaryPathsByVersion[currentVersion] = {};
    const neededVersion = neededVersions[currentVersion];
    if (neededVersion.binaryTargets.length === 0) {
      neededVersion.binaryTargets = [{ fromEnvVar: null, value: binaryTarget }];
    }
    if (process.env.NETLIFY) {
      const isNodeMajor20OrUp = parseInt(process.versions.node.split(".")[0]) >= 20;
      const awsRuntimeVersion = (0, import_chunk_2SDPW6AX.parseAWSNodejsRuntimeEnvVarVersion)();
      const isRuntimeEnvVar20OrUp = awsRuntimeVersion && awsRuntimeVersion >= 20;
      const isRuntimeEnvVar18OrDown = awsRuntimeVersion && awsRuntimeVersion <= 18;
      const isRhelBinaryTarget1xInNeededVersions = neededVersion.binaryTargets.find(
        (object) => object.value === "rhel-openssl-1.0.x"
      );
      const isRhelBinaryTarget3xInNeededVersions = neededVersion.binaryTargets.find(
        (object) => object.value === "rhel-openssl-3.0.x"
      );
      if (!isRhelBinaryTarget3xInNeededVersions && (isNodeMajor20OrUp || isRuntimeEnvVar20OrUp) && !isRuntimeEnvVar18OrDown) {
        neededVersion.binaryTargets.push({
          fromEnvVar: null,
          value: "rhel-openssl-3.0.x"
        });
      } else if (!isRhelBinaryTarget1xInNeededVersions) {
        neededVersion.binaryTargets.push({
          fromEnvVar: null,
          value: "rhel-openssl-1.0.x"
        });
      }
    }
    let binaryTargetBaseDir = eval(`require('path').join(__dirname, '..')`);
    if (version !== currentVersion) {
      binaryTargetBaseDir = import_path.default.join(binaryTargetBaseDir, `./engines/${currentVersion}/`);
      await (0, import_fs_extra.ensureDir)(binaryTargetBaseDir).catch((e) => console.error(e));
    }
    const binariesConfig = neededVersion.engines.reduce((acc, curr) => {
      if (!binaryPathsOverride?.[curr]) {
        acc[(0, import_chunk_4CGPN5SR.engineTypeToBinaryType)(curr)] = binaryTargetBaseDir;
      }
      return acc;
    }, /* @__PURE__ */ Object.create(null));
    if (Object.values(binariesConfig).length > 0) {
      const binaryTargets = neededVersion.binaryTargets.map(
        (binaryTarget2) => binaryTarget2.value
      );
      const downloadParams = {
        binaries: binariesConfig,
        binaryTargets,
        showProgress: typeof printDownloadProgress === "boolean" ? printDownloadProgress : true,
        version: currentVersion && currentVersion !== "latest" ? currentVersion : import_engines.enginesVersion,
        skipDownload
      };
      const binaryPathsWithEngineType = await (0, import_fetch_engine.download)(downloadParams);
      const binaryPaths = (0, import_chunk_7B5PXS6N.mapKeys)(binaryPathsWithEngineType, import_chunk_RS2R7COT.binaryTypeToEngineType);
      binaryPathsByVersion[currentVersion] = binaryPaths;
    }
    if (binaryPathsOverride) {
      const overrideEngines = Object.keys(binaryPathsOverride);
      const enginesCoveredByOverride = neededVersion.engines.filter((engine) => overrideEngines.includes(engine));
      if (enginesCoveredByOverride.length > 0) {
        for (const engine of enginesCoveredByOverride) {
          const enginePath = binaryPathsOverride[engine];
          binaryPathsByVersion[currentVersion][engine] = {
            [binaryTarget]: enginePath
          };
        }
      }
    }
  }
  return binaryPathsByVersion;
}
