"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_E3APO3ZG_exports = {};
__export(chunk_E3APO3ZG_exports, {
  createDirIfNotExists: () => createDirIfNotExists,
  fs_utils_exports: () => fs_utils_exports,
  getFilesInDir: () => getFilesInDir,
  getNestedFoldersInDir: () => getNestedFoldersInDir,
  getTopLevelFoldersInDir: () => getTopLevelFoldersInDir,
  removeEmptyDirs: () => removeEmptyDirs,
  writeFile: () => writeFile
});
module.exports = __toCommonJS(chunk_E3APO3ZG_exports);
var import_chunk_J77ZIDXB = require("./chunk-J77ZIDXB.js");
var import_chunk_KKMREGHN = require("./chunk-KKMREGHN.js");
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_promises = __toESM(require("fs/promises"));
var import_path = __toESM(require("path"));
var fs_utils_exports = {};
(0, import_chunk_WWAWV7DQ.__export)(fs_utils_exports, {
  createDirIfNotExists: () => createDirIfNotExists,
  getFilesInDir: () => getFilesInDir,
  getNestedFoldersInDir: () => getNestedFoldersInDir,
  getTopLevelFoldersInDir: () => getTopLevelFoldersInDir,
  removeEmptyDirs: () => removeEmptyDirs,
  writeFile: () => writeFile
});
var import_globby = (0, import_chunk_WWAWV7DQ.__toESM)((0, import_chunk_KKMREGHN.require_globby)());
function createDirIfNotExists(dir) {
  return import_promises.default.mkdir(dir, { recursive: true });
}
function writeFile({ path: path2, content }) {
  return import_promises.default.writeFile(path2, content, { encoding: "utf-8" });
}
async function getTopLevelFoldersInDir(dir) {
  const rawFolders = await import_promises.default.readdir(dir, { withFileTypes: true });
  return rawFolders.filter((fileOrFolder) => fileOrFolder.isDirectory()).map((folder) => (0, import_chunk_J77ZIDXB.pathToPosix)(import_path.default.join(dir, folder.name)));
}
function getNestedFoldersInDir(dir) {
  const normalizedDir = (0, import_chunk_J77ZIDXB.pathToPosix)(import_path.default.join(dir, "**"));
  return (0, import_globby.default)(normalizedDir, { onlyFiles: false, onlyDirectories: true });
}
function getFilesInDir(dir, pattern = "**") {
  const normalizedDir = (0, import_chunk_J77ZIDXB.pathToPosix)(import_path.default.join(dir, pattern));
  return (0, import_globby.default)(normalizedDir, { onlyFiles: true, onlyDirectories: false });
}
async function removeEmptyDirs(dir) {
  try {
    const fileStats = await import_promises.default.lstat(dir);
    if (!fileStats.isDirectory()) {
      return;
    }
  } catch (e) {
    return;
  }
  const filenames = await import_promises.default.readdir(dir);
  if (filenames.length > 0) {
    const recursionPromises = filenames.map((filename) => removeEmptyDirs(import_path.default.join(dir, filename)));
    await Promise.all(recursionPromises);
  }
  const filenamesAfterRec = await import_promises.default.readdir(dir);
  if (filenamesAfterRec.length === 0) {
    await import_promises.default.rmdir(dir);
  }
}
