"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_HMGEWJDY_exports = {};
__export(chunk_HMGEWJDY_exports, {
  exists: () => exists,
  loadEnv: () => loadEnv,
  pathsEqual: () => pathsEqual,
  tryLoadEnvs: () => tryLoadEnvs
});
module.exports = __toCommonJS(chunk_HMGEWJDY_exports);
var import_chunk_T2PM5TKT = require("./chunk-T2PM5TKT.js");
var import_chunk_PG5FDKSF = require("./chunk-PG5FDKSF.js");
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_debug = __toESM(require("@prisma/debug"));
var import_fs = __toESM(require("fs"));
var import_path = __toESM(require("path"));
var require_package = (0, import_chunk_WWAWV7DQ.__commonJS)({
  "../../node_modules/.pnpm/dotenv@16.0.3/node_modules/dotenv/package.json"(exports, module2) {
    module2.exports = {
      name: "dotenv",
      version: "16.0.3",
      description: "Loads environment variables from .env file",
      main: "lib/main.js",
      types: "lib/main.d.ts",
      exports: {
        ".": {
          require: "./lib/main.js",
          types: "./lib/main.d.ts",
          default: "./lib/main.js"
        },
        "./config": "./config.js",
        "./config.js": "./config.js",
        "./lib/env-options": "./lib/env-options.js",
        "./lib/env-options.js": "./lib/env-options.js",
        "./lib/cli-options": "./lib/cli-options.js",
        "./lib/cli-options.js": "./lib/cli-options.js",
        "./package.json": "./package.json"
      },
      scripts: {
        "dts-check": "tsc --project tests/types/tsconfig.json",
        lint: "standard",
        "lint-readme": "standard-markdown",
        pretest: "npm run lint && npm run dts-check",
        test: "tap tests/*.js --100 -Rspec",
        prerelease: "npm test",
        release: "standard-version"
      },
      repository: {
        type: "git",
        url: "git://github.com/motdotla/dotenv.git"
      },
      keywords: [
        "dotenv",
        "env",
        ".env",
        "environment",
        "variables",
        "config",
        "settings"
      ],
      readmeFilename: "README.md",
      license: "BSD-2-Clause",
      devDependencies: {
        "@types/node": "^17.0.9",
        decache: "^4.6.1",
        dtslint: "^3.7.0",
        sinon: "^12.0.1",
        standard: "^16.0.4",
        "standard-markdown": "^7.1.0",
        "standard-version": "^9.3.2",
        tap: "^15.1.6",
        tar: "^6.1.11",
        typescript: "^4.5.4"
      },
      engines: {
        node: ">=12"
      }
    };
  }
});
var require_main = (0, import_chunk_WWAWV7DQ.__commonJS)({
  "../../node_modules/.pnpm/dotenv@16.0.3/node_modules/dotenv/lib/main.js"(exports, module2) {
    "use strict";
    var fs2 = (0, import_chunk_WWAWV7DQ.__require)("fs");
    var path2 = (0, import_chunk_WWAWV7DQ.__require)("path");
    var os = (0, import_chunk_WWAWV7DQ.__require)("os");
    var packageJson = require_package();
    var version = packageJson.version;
    var LINE = /(?:^|^)\s*(?:export\s+)?([\w.-]+)(?:\s*=\s*?|:\s+?)(\s*'(?:\\'|[^'])*'|\s*"(?:\\"|[^"])*"|\s*`(?:\\`|[^`])*`|[^#\r\n]+)?\s*(?:#.*)?(?:$|$)/mg;
    function parse(src) {
      const obj = {};
      let lines = src.toString();
      lines = lines.replace(/\r\n?/mg, "\n");
      let match;
      while ((match = LINE.exec(lines)) != null) {
        const key = match[1];
        let value = match[2] || "";
        value = value.trim();
        const maybeQuote = value[0];
        value = value.replace(/^(['"`])([\s\S]*)\1$/mg, "$2");
        if (maybeQuote === '"') {
          value = value.replace(/\\n/g, "\n");
          value = value.replace(/\\r/g, "\r");
        }
        obj[key] = value;
      }
      return obj;
    }
    function _log(message) {
      console.log(`[dotenv@${version}][DEBUG] ${message}`);
    }
    function _resolveHome(envPath) {
      return envPath[0] === "~" ? path2.join(os.homedir(), envPath.slice(1)) : envPath;
    }
    function config(options) {
      let dotenvPath = path2.resolve(process.cwd(), ".env");
      let encoding = "utf8";
      const debug2 = Boolean(options && options.debug);
      const override = Boolean(options && options.override);
      if (options) {
        if (options.path != null) {
          dotenvPath = _resolveHome(options.path);
        }
        if (options.encoding != null) {
          encoding = options.encoding;
        }
      }
      try {
        const parsed = DotenvModule.parse(fs2.readFileSync(dotenvPath, { encoding }));
        Object.keys(parsed).forEach(function(key) {
          if (!Object.prototype.hasOwnProperty.call(process.env, key)) {
            process.env[key] = parsed[key];
          } else {
            if (override === true) {
              process.env[key] = parsed[key];
            }
            if (debug2) {
              if (override === true) {
                _log(`"${key}" is already defined in \`process.env\` and WAS overwritten`);
              } else {
                _log(`"${key}" is already defined in \`process.env\` and was NOT overwritten`);
              }
            }
          }
        });
        return { parsed };
      } catch (e) {
        if (debug2) {
          _log(`Failed to load ${dotenvPath} ${e.message}`);
        }
        return { error: e };
      }
    }
    var DotenvModule = {
      config,
      parse
    };
    module2.exports.config = DotenvModule.config;
    module2.exports.parse = DotenvModule.parse;
    module2.exports = DotenvModule;
  }
});
var import_dotenv = (0, import_chunk_WWAWV7DQ.__toESM)(require_main());
var debug = (0, import_debug.default)("prisma:tryLoadEnv");
function tryLoadEnvs({
  rootEnvPath,
  schemaEnvPath
}, opts = {
  conflictCheck: "none"
}) {
  const rootEnvInfo = loadEnv(rootEnvPath);
  if (opts.conflictCheck !== "none") {
    checkForConflicts(rootEnvInfo, schemaEnvPath, opts.conflictCheck);
  }
  let schemaEnvInfo = null;
  if (!pathsEqual(rootEnvInfo?.path, schemaEnvPath)) {
    schemaEnvInfo = loadEnv(schemaEnvPath);
  }
  if (!rootEnvInfo && !schemaEnvInfo) {
    debug("No Environment variables loaded");
  }
  if (schemaEnvInfo?.dotenvResult.error) {
    return console.error((0, import_chunk_PG5FDKSF.red)((0, import_chunk_PG5FDKSF.bold)("Schema Env Error: ")) + schemaEnvInfo.dotenvResult.error);
  }
  const messages = [rootEnvInfo?.message, schemaEnvInfo?.message].filter(Boolean);
  return {
    message: messages.join("\n"),
    parsed: {
      ...rootEnvInfo?.dotenvResult?.parsed,
      ...schemaEnvInfo?.dotenvResult?.parsed
    }
  };
}
function checkForConflicts(rootEnvInfo, envPath, type) {
  const parsedRootEnv = rootEnvInfo?.dotenvResult.parsed;
  const areNotTheSame = !pathsEqual(rootEnvInfo?.path, envPath);
  if (parsedRootEnv && envPath && areNotTheSame && import_fs.default.existsSync(envPath)) {
    const envConfig = import_dotenv.default.parse(import_fs.default.readFileSync(envPath));
    const conflicts = [];
    for (const k in envConfig) {
      if (parsedRootEnv[k] === envConfig[k]) {
        conflicts.push(k);
      }
    }
    if (conflicts.length > 0) {
      const relativeRootEnvPath = import_path.default.relative(process.cwd(), rootEnvInfo.path);
      const relativeEnvPath = import_path.default.relative(process.cwd(), envPath);
      if (type === "error") {
        const message = `There is a conflict between env var${conflicts.length > 1 ? "s" : ""} in ${(0, import_chunk_PG5FDKSF.underline)(
          relativeRootEnvPath
        )} and ${(0, import_chunk_PG5FDKSF.underline)(relativeEnvPath)}
Conflicting env vars:
${conflicts.map((conflict) => `  ${(0, import_chunk_PG5FDKSF.bold)(conflict)}`).join("\n")}

We suggest to move the contents of ${(0, import_chunk_PG5FDKSF.underline)(relativeEnvPath)} to ${(0, import_chunk_PG5FDKSF.underline)(
          relativeRootEnvPath
        )} to consolidate your env vars.
`;
        throw new Error(message);
      } else if (type === "warn") {
        const message = `Conflict for env var${conflicts.length > 1 ? "s" : ""} ${conflicts.map((c) => (0, import_chunk_PG5FDKSF.bold)(c)).join(", ")} in ${(0, import_chunk_PG5FDKSF.underline)(relativeRootEnvPath)} and ${(0, import_chunk_PG5FDKSF.underline)(relativeEnvPath)}
Env vars from ${(0, import_chunk_PG5FDKSF.underline)(relativeEnvPath)} overwrite the ones from ${(0, import_chunk_PG5FDKSF.underline)(relativeRootEnvPath)}
      `;
        console.warn(`${(0, import_chunk_PG5FDKSF.yellow)("warn(prisma)")} ${message}`);
      }
    }
  }
}
function loadEnv(envPath) {
  if (exists(envPath)) {
    debug(`Environment variables loaded from ${envPath}`);
    const dotenvOutput = import_dotenv.default.config({
      path: envPath,
      // Useful to debug dotenv parsing, prints errors & warnings
      // Set to any value to enable
      // Example for empty .env file
      // [dotenv][DEBUG] did not match key and value when parsing line 1:
      //
      // Value needs to be null or undefined, false is truthy
      // https://github.com/motdotla/dotenv/blob/7301ac9be0b2c766f865bbe24280bf82586d25aa/lib/main.js#L89-L91
      debug: process.env.DOTENV_CONFIG_DEBUG ? true : void 0
    });
    const dotenvExpandOutput = (0, import_chunk_T2PM5TKT.dotenvExpand)(dotenvOutput);
    return {
      dotenvResult: dotenvExpandOutput,
      message: (0, import_chunk_PG5FDKSF.dim)(`Environment variables loaded from ${import_path.default.relative(process.cwd(), envPath)}`),
      path: envPath
    };
  } else {
    debug(`Environment variables not found at ${envPath}`);
  }
  return null;
}
function pathsEqual(path1, path2) {
  return path1 && path2 && import_path.default.resolve(path1) === import_path.default.resolve(path2);
}
function exists(p) {
  return Boolean(p && import_fs.default.existsSync(p));
}
