"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_KLW6LRVQ_exports = {};
__export(chunk_KLW6LRVQ_exports, {
  MergeSchemasError: () => MergeSchemasError,
  mergeSchemas: () => mergeSchemas
});
module.exports = __toCommonJS(chunk_KLW6LRVQ_exports);
var import_chunk_YRBRUREX = require("./chunk-YRBRUREX.js");
var import_chunk_EKSAMZHR = require("./chunk-EKSAMZHR.js");
var import_chunk_WMIBAVWZ = require("./chunk-WMIBAVWZ.js");
var import_chunk_377DM2ES = require("./chunk-377DM2ES.js");
var import_chunk_SMHAELKS = require("./chunk-SMHAELKS.js");
var import_chunk_H3T4L34H = require("./chunk-H3T4L34H.js");
var import_chunk_XHAV7VB6 = require("./chunk-XHAV7VB6.js");
var import_chunk_A4QWQE3W = require("./chunk-A4QWQE3W.js");
var import_chunk_JM6ICT4D = require("./chunk-JM6ICT4D.js");
var import_chunk_PG5FDKSF = require("./chunk-PG5FDKSF.js");
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_debug = __toESM(require("@prisma/debug"));
var import_function = (0, import_chunk_WWAWV7DQ.__toESM)((0, import_chunk_SMHAELKS.require_function)());
var debug = (0, import_debug.default)("prisma:mergeSchemas");
var MergeSchemasError = class extends Error {
  constructor(params) {
    const constructedErrorMessage = (0, import_chunk_H3T4L34H.$)(params).with({ _tag: "parsed" }, ({ errorCode, message, reason }) => {
      const errorCodeMessage = errorCode ? `Error code: ${errorCode}` : "";
      return `${reason}
${errorCodeMessage}
${(0, import_chunk_WMIBAVWZ.relativizePathInPSLError)(message)}`;
    }).with({ _tag: "unparsed" }, ({ message, reason }) => {
      const detailsHeader = (0, import_chunk_PG5FDKSF.red)((0, import_chunk_PG5FDKSF.bold)("Details:"));
      return `${reason}
${detailsHeader} ${message}`;
    }).exhaustive();
    const errorMessageWithContext = `${constructedErrorMessage}
[Context: mergeSchemas]`;
    super((0, import_chunk_377DM2ES.addVersionDetailsToErrorMessage)(errorMessageWithContext));
    this.name = "MergeSchemasError";
  }
};
function mergeSchemas(options) {
  const debugErrorType = (0, import_chunk_EKSAMZHR.createDebugErrorType)(debug, "mergeSchemasWasm");
  debug(`Using mergeSchemas Wasm`);
  const mergeSchemasEither = (0, import_function.pipe)(
    (0, import_chunk_JM6ICT4D.tryCatch)(
      () => {
        const params = JSON.stringify({
          schema: options.schemas
        });
        return import_chunk_XHAV7VB6.prismaSchemaWasm.merge_schemas(params);
      },
      (e) => ({
        type: "wasm-error",
        reason: "(mergeSchemas wasm)",
        error: e
      })
    )
  );
  if ((0, import_chunk_JM6ICT4D.isRight)(mergeSchemasEither)) {
    return mergeSchemasEither.right;
  }
  const error = (0, import_chunk_H3T4L34H.$)(mergeSchemasEither.left).with({ type: "wasm-error" }, (e) => {
    debugErrorType(e);
    console.error("");
    if ((0, import_chunk_A4QWQE3W.isWasmPanic)(e.error)) {
      const { message, stack } = (0, import_chunk_A4QWQE3W.getWasmError)(e.error);
      debug(`Error merging schemas: ${message}`);
      debug(stack);
      const panic = new import_chunk_A4QWQE3W.RustPanic(
        /* message */
        message,
        /* rustStack */
        stack,
        /* request */
        "@prisma/prisma-schema-wasm merge_schemas",
        "FMT_CLI",
        /* schemaPath */
        (0, import_chunk_YRBRUREX.debugMultipleSchemaPaths)(options.schemas),
        /* schema */
        options.schemas
      );
      return panic;
    }
    const errorOutput = e.error.message;
    return new MergeSchemasError((0, import_chunk_EKSAMZHR.parseQueryEngineError)({ errorOutput, reason: e.reason }));
  }).exhaustive();
  throw error;
}
