"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var chunk_OSOXVAZB_exports = {};
__export(chunk_OSOXVAZB_exports, {
  locateLocalCloudflareD1: () => locateLocalCloudflareD1
});
module.exports = __toCommonJS(chunk_OSOXVAZB_exports);
var import_chunk_H3T4L34H = require("./chunk-H3T4L34H.js");
var import_chunk_KKMREGHN = require("./chunk-KKMREGHN.js");
var import_chunk_WWAWV7DQ = require("./chunk-WWAWV7DQ.js");
var import_path = __toESM(require("path"));
var import_process = __toESM(require("process"));
var import_fast_glob = (0, import_chunk_WWAWV7DQ.__toESM)((0, import_chunk_KKMREGHN.require_out)());
var import_globby = (0, import_chunk_WWAWV7DQ.__toESM)((0, import_chunk_KKMREGHN.require_globby)());
var defaultD1DirPath = import_path.default.join(".wrangler", "state", "v3", "d1", "miniflare-D1DatabaseObject");
async function locateLocalCloudflareD1({ arg }) {
  const cwd = import_process.default.cwd();
  const d1DirPath = import_path.default.posix.join(cwd, defaultD1DirPath);
  const pathConverted = (0, import_fast_glob.convertPathToPattern)(d1DirPath);
  const d1Databases = await (0, import_globby.default)(import_path.default.posix.join(pathConverted, "*.sqlite"), {});
  if (d1Databases.length === 0) {
    throw new Error(
      `No Cloudflare D1 databases found in ${defaultD1DirPath}. Did you run \`wrangler d1 create <DATABASE_NAME>\` and \`wrangler dev\`?`
    );
  }
  if (d1Databases.length > 1) {
    const { originalArg, recommendedArg } = (0, import_chunk_H3T4L34H.$)(arg).with("--to-local-d1", (originalArg2) => ({
      originalArg: originalArg2,
      recommendedArg: "--to-url file:"
    })).with("--from-local-d1", (originalArg2) => ({
      originalArg: originalArg2,
      recommendedArg: "--from-url file:"
    })).exhaustive();
    throw new Error(
      `Multiple Cloudflare D1 databases found in ${defaultD1DirPath}. Please manually specify the local D1 database with \`${recommendedArg}\`, without using the \`${originalArg}\` flag.`
    );
  }
  const d1Database = d1Databases[0];
  return d1Database;
}
